/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

public class NetworkValidator {
    public static final int RETURN_OK = 0;
    public static final int RETURN_INVALID_IP = 1;
    public static final int RETURN_RESTRICTED_IP = 2;
    public static final int RETURN_IP_EQ_BC = 3;
    public static final int RETURN_IP_EQ_SN = 4;
    public static final int RETURN_IP_RESERVED = 5;
    public static final int RETURN_INVALID_NM = 6;
    public static final int RETURN_INVALID_GW = 7;
    public static final int RETURN_GW_UNREACHABLE = 8;
    public static final int RETURN_INVALID_DNS1 = 9;
    public static final int RETURN_INVALID_DNS2 = 10;
    public static final int RETURN_INVALID_DNS3 = 11;
    public static final String[] RESTRICTED_IP = new String[]{"0.", "127.", "192.88.99.", "224.", "225.", "226.", "227.", "228.", "229.", "230.", "231.", "232.", "233.", "234.", "235.", "236.", "237.", "238.", "239.", "255.255.255.255"};

    public static int validate(String string, String string2, String string3, String string4, String string5, String string6) {
        int n;
        int n2;
        String string72;
        byte[] byArray = NetworkValidator.getBytes(string);
        if (byArray == null) {
            return 1;
        }
        for (String string72 : RESTRICTED_IP) {
            if (!string.startsWith(string72)) continue;
            return 2;
        }
        byte[] byArray2 = NetworkValidator.getBytes(string2);
        if (byArray2 == null) {
            return 6;
        }
        int n3 = NetworkValidator.getAsInt(byArray);
        int n4 = NetworkValidator.getAsInt(byArray2);
        string72 = Integer.toBinaryString(n4);
        if (string72.length() == 32 && string72.charAt(0) == '1' && string72.charAt(31) == '0' && string72.charAt(30) == '0') {
            n2 = 1;
            for (n = 1; n < 30; ++n) {
                if (n2 != 0) {
                    n2 = string72.charAt(n) == '1' ? 1 : 0;
                    continue;
                }
                if (string72.charAt(n) != '1') continue;
                return 6;
            }
        } else {
            return 6;
        }
        n2 = n3 & n4;
        n = n2 | ~n4;
        if (n3 == n2) {
            return 4;
        }
        if (n3 == n) {
            return 3;
        }
        if (string3.length() > 0) {
            byte[] byArray3 = NetworkValidator.getBytes(string3);
            if (byArray3 == null) {
                return 7;
            }
            int n5 = NetworkValidator.getAsInt(byArray3);
            if ((n3 & n4) != (n5 & n4)) {
                return 8;
            }
        }
        if (string4.length() > 0 && NetworkValidator.getBytes(string4) == null) {
            return 9;
        }
        if (string5.length() > 0 && NetworkValidator.getBytes(string5) == null) {
            return 10;
        }
        if (string6.length() > 0 && NetworkValidator.getBytes(string6) == null) {
            return 11;
        }
        return 0;
    }

    private static int getAsInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static String getBroadcast(String string, String string2) {
        byte[] byArray = NetworkValidator.getBytes(string);
        byte[] byArray2 = NetworkValidator.getBytes(string2);
        return Integer.toString((~byArray2[0] | byArray[0]) & 0xFF) + "." + Integer.toString((~byArray2[1] | byArray[1]) & 0xFF) + "." + Integer.toString((~byArray2[2] | byArray[2]) & 0xFF) + "." + Integer.toString((~byArray2[3] | byArray[3]) & 0xFF);
    }

    private static byte[] getBytes(String string) {
        byte[] byArray = new byte[4];
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                if (n < 0 || n > 255) {
                    return null;
                }
                byArray[i] = (byte)n;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return byArray;
    }
}

