<?xml version="1.0"?> 
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml"/>
<xsl:template match="/">
<html><head></head>
<body>

<xsl:variable name="LANG" select="document('lang/de_lang.xml')"/>
<xsl:variable name="error" select="$LANG//error"/>
<xsl:variable name="bin" select="$LANG//bin"/>
<xsl:variable name="analog" select="$LANG//analog"/>
<xsl:variable name="file" select="$LANG//file"/>
<xsl:variable name="datetime" select="$LANG//datetime"/>
<xsl:variable name="string" select="$LANG//string"/>

<!-- Begin Header Output Screen ##################################//-->

		<table id="screenheader" width="95%" align="center" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<th align="left" valign="top" width="30%">
				<img src="img/report.gif" alt="" width="46" height="46" border="0"></img>
				<!-- <div style="color:#0206AC;"><xsl:value-of select="$LANG//report"/></div> -->
				</th>
				<th align="right" valign="middle" colspan="2" width="70%">
					<div style="color:#0206AC;">
						<xsl:value-of select="$LANG//version"/>:&#160;
						<xsl:value-of select="//REPORT/@VERSION"/>&#160;
						<xsl:value-of select="$LANG//from"/>: <xsl:value-of select="//REPORT/@CREATION"/>
					</div>
					<br />
				</th>
			</tr>
			<tr>
				<th align="center" colspan="3" width="100%">
					<div style="color:#C00000"><font size="2">
						<xsl:value-of select="//REPORT/PROJECT/@NAME"/>
					</font></div>
				</th>
			</tr>
			<tr>
				<td align="left" colspan="3">
					<hr align="left" />
				</td>
			</tr>
			<tr>
				<td align="left" width="30%">
					<xsl:value-of select="$LANG//author"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/@AUTHOR"/>
				</td>
				<td rowspan="2" align="center" width="35%">
					<xsl:value-of select="$LANG//descr"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/@DESCR"/>
				</td>
				<td align="right" width="30%">
					<xsl:value-of select="$LANG//created"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/@CREATION"/>
				</td>
			</tr>
			<tr>
				<td align="left" width="30%">
					<xsl:value-of select="$LANG//countof"/>&#160;
					<xsl:value-of select="$LANG//sheets"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/SHEETS/@COUNT"/>
				</td>
				<td align="right" width="30%">
					<xsl:value-of select="$LANG//akt"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/@MODIFICATION"/>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="3">
					<hr align="left" />
				</td>
			</tr>
			<xsl:for-each select="//REPORT/PROJECT/PROCESSMODELS/PROCESSMODEL">
			<tr>
				<td align="center" width="100%" colspan="3">
					<xsl:value-of select="$LANG//connected"/>&#160;
					<xsl:value-of select="$LANG//to"/>&#160;
					<xsl:value-of select="$LANG//process"/>:&#160;
					<xsl:value-of select="@NAME"/>&#160;&#160;&#160;&#160;&#160;
					<xsl:value-of select="$LANG//guid"/>:&#160;
					<xsl:value-of select="@GUID"/>
				</td>
			</tr>
			</xsl:for-each>
			<tr>
				<td  align="left" colspan="3">
					<hr align="left" />
				</td>
			</tr>
			<tr>
				<td align="left" width="65%" colspan="2">
					<xsl:value-of select="$LANG//prj"/>&#160;
					<xsl:value-of select="$LANG//guid"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/@GUID"/>
				</td>
				<td align="right" width="30%">
					<xsl:value-of select="$LANG//scaling"/>:&#160;
					<xsl:value-of select="//REPORT/PROJECT/RESOLUTION/@HORZ"/> x 
					<xsl:value-of select="//REPORT/PROJECT/RESOLUTION/@VERT"/>
				</td>
			</tr>
		</table>

<!-- End Header Output Screen ####################################//-->

<xsl:for-each select="//REPORT/PROJECT/SHEETS/SHEET">

<!-- Begin Header Output Print ###################################//-->

		<table id="header" width="95%" align="center" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<th align="left" width="30%">
					<div style="color:#0206AC;"><xsl:value-of select="$LANG//report"/></div>
				</th>
				<td align="right" colspan="2" width="70%">
					<div style="color:#0206AC; font-weight:bold;">
						<xsl:value-of select="$LANG//version"/>:&#160;
						<xsl:value-of select="../../../@VERSION"/>&#160;
						<xsl:value-of select="$LANG//from"/>:&#160;
						<xsl:value-of select="../../../@CREATION"/>
					</div>
					<br />
				</td>
			</tr>
			<tr>
				<th align="center" colspan="3" width="100%">
					<div style="color:#C00000;"><font size="2">
						<xsl:value-of select="../../@NAME"/>
					</font></div>
				</th>
			</tr>
			<tr>
				<td align="left" colspan="3">
					<hr align="left" />
				</td>
			</tr>
			<tr>
				<td align="left" width="30%">
					<xsl:value-of select="$LANG//author"/>:&#160;
					<xsl:value-of select="../../@AUTHOR"/>
				</td>
				<td rowspan="2" align="center" width="35%">
					<xsl:value-of select="$LANG//descr"/>:&#160;
					<xsl:value-of select="../../@DESCR"/>
				</td>
				<td align="right" width="30%">
					<xsl:value-of select="$LANG//created"/>:&#160;
					<xsl:value-of select="../../@CREATION"/>
				</td>
			</tr>
			<tr>
				<td align="left" width="30%">
					<xsl:value-of select="$LANG//countof"/>&#160;
					<xsl:value-of select="$LANG//sheets"/>:&#160;
					<xsl:value-of select="../@COUNT"/>
				</td>
				<td align="right" width="30%">
					<xsl:value-of select="$LANG//akt"/>:&#160;
					<xsl:value-of select="../../@MODIFICATION"/>
				</td>
			</tr>
			<tr>
				<td  align="left" colspan="3">
					<hr align="left" />
				</td>
			</tr>
			<xsl:for-each select="../../PROCESSMODELS/PROCESSMODEL">
			<tr>
				<td align="center" width="100%" colspan="3">
					<xsl:value-of select="$LANG//connected"/>&#160;
					<xsl:value-of select="$LANG//to"/>&#160;
					<xsl:value-of select="$LANG//process"/>:&#160;
					<xsl:value-of select="@NAME"/>&#160;&#160;&#160;&#160;&#160;
					<xsl:value-of select="$LANG//guid"/>:&#160;
					<xsl:value-of select="@GUID"/>
				</td>
			</tr>
			</xsl:for-each>
			<tr>
				<td  align="left" colspan="3">
					<hr align="left" />
				</td>
			</tr>
			<tr>
				<td align="left" width="65%" colspan="2">
					<xsl:value-of select="$LANG//prj"/>:&#160;
					<xsl:value-of select="$LANG//guid"/>:&#160;
					<xsl:value-of select="../../@GUID"/>
				</td>
				<td align="right" width="30%">
					<xsl:value-of select="$LANG//scaling"/>:&#160;
					<xsl:value-of select="../../RESOLUTION/@HORZ"/> x 
					<xsl:value-of select="../../RESOLUTION/@VERT"/>
				</td>
			</tr>
		</table>

<DIV ID="bigspace"></DIV>

<!-- End Header Output Print #####################################//-->
<!-- Begin Sheet Header ##########################################//-->

<DIV ID="space">
<table width="95%" border="1" cellspacing="0" cellpadding="2" align="center" bordercolorlight="#FFFFFF" bordercolordark="#808080" frame="hsides" rules="all">
		<tr class="thprinterfriendly">
			<th align="center" colspan="3">
					<xsl:value-of select="$LANG//sheet"/>:&#160;
					<xsl:value-of select="@NAME"/>
			</th>
		</tr>
		<tr class="tdprinterfriendly">
			<th align="left" width="20%">
					<xsl:value-of select="$LANG//author"/>:
			</th>
			<th align="left" width="80%" colspan="2">
					<xsl:value-of select="$LANG//descr"/>:
			</th>
		</tr>
		<tr>
   	   <th align="left" width="20%">
				<xsl:value-of select="@AUTHOR"/>
			</th>
   	   <th align="left" width="48%">
				<xsl:value-of select="@DESCR"/>
			</th>
   	   <th align="left" width="32%" class="guid">
				<xsl:value-of select="$LANG//guid"/>:&#160;
				<xsl:value-of select="@GUID"/>
			</th>
		</tr>
		<tr>
   	   <th align="left" height="5" colspan="3">
			
			</th>
		</tr>
		<tr class="tdprinterfriendly">
   	   <th align="left" colspan="3">
				<xsl:value-of select="$LANG//image"/>:		
			</th>
		</tr>

<!-- Begin Sheet Image ###########################################//-->

		<tr class="tdprinterfriendly">
	      <td valign="middle" align="center" colspan="3" bgcolor="#FFFFFF">
			<xsl:for-each select="IMAGE">
				<img><xsl:attribute name="width"><xsl:value-of select="@WIDTH" /></xsl:attribute>
				<xsl:attribute name="height"><xsl:value-of select="@HEIGHT" /></xsl:attribute>
				<xsl:attribute name="src"><xsl:value-of select="@HREF" /></xsl:attribute></img>&#160;
			</xsl:for-each>
			</td>
		</tr>
		
<!-- Begin Sheet Planes ###########################################//-->
		
		<tr class="thprinterfriendly">
	      <th valign="top" width="100%" align="left" colspan="3">
					<xsl:value-of select="$LANG//countof"/>&#160;
					<xsl:value-of select="$LANG//planes"/>:&#160;
					<xsl:value-of select="SHEETPLANES/@COUNT"/>
			</th>
		</tr>
		<tr>
	      <td valign="top" width="100%" align="left" colspan="3">
			<xsl:for-each select="SHEETPLANES/SHEETPLANE">
				<DIV ID="space">
				<table width="100%" border="1" cellspacing="0" cellpadding="2" align="center" bordercolorlight="#FFFFFF" bordercolordark="#808080" frame="hsides" rules="all">
					<tr class="thprinterfriendly">
						<th align="left" width="20%">
							<xsl:value-of select="@NAME"/>
						</th>
						<th colspan="3" width="48%">
							&#160;
 						</th>
						<th align="left" width="32%" class="guid">
							<xsl:value-of select="$LANG//guid"/>:&#160;
							<xsl:value-of select="@GUID"/>
 						</th>
					</tr>
					<xsl:for-each select="SHEETITEM[1]">
					<tr class="tdprinterfriendly">
						<th align="left" width="20%">
							<xsl:value-of select="$LANG//type"/>
						</th>
						<th align="left" width="28%">
							<xsl:value-of select="$LANG//name"/>
						</th>
						<th align="left" width="10%">
							<xsl:value-of select="$LANG//pos"/>&#160;(x, y)
						</th>
						<th align="left" width="10%">
							<xsl:value-of select="$LANG//extent"/>&#160;
							(<xsl:value-of select="$LANG//width"/>&#160;&#160;x&#160;
							<xsl:value-of select="$LANG//height"/>)
						</th>
						<th align="left" width="32%">
							&#160;
						</th>
					</tr>
					</xsl:for-each>
					<xsl:for-each select="SHEETITEM">
					<tr>
						<th align="left">
							<xsl:value-of select="@TYPE"/>
				 		</th>
						<th align="left">
							<xsl:value-of select="@NAME"/>
						</th>
						<th align="left">
							<xsl:value-of select="RECT/@LEFT"/>,&#160;
							<xsl:value-of select="RECT/@TOP"/>
						</th>
						<th align="left">
							<xsl:value-of select="RECT/@WIDTH"/>&#160;x
							<xsl:value-of select="RECT/@HEIGHT"/>
						</th>
						<th align="left" class="guid">
							<xsl:value-of select="$LANG//guid"/>:&#160;
							<xsl:value-of select="@GUID"/>
						</th>
					</tr>
					</xsl:for-each>
				</table>
				</DIV>
			</xsl:for-each>
				<DIV ID="space"></DIV>
			</td>
		</tr>

<!-- Begin Sheet Links #####################################//-->
		
		<tr class="thprinterfriendly">
   	   <th valign="top" width="100%" align="left" colspan="3">
				<xsl:value-of select="$LANG//link"/>:&#160;
			</th>
		</tr>
		<tr class="tdprinterfriendly">
   	   <th valign="top" width="100%" align="left" colspan="3">
				<table width="100%" border="1" cellspacing="0" cellpadding="2" align="center" bordercolorlight="#FFFFFF" bordercolordark="#808080" frame="hsides" rules="all">
					<xsl:for-each select="SHEETLINKS/SHEETLINK[1]">
					<tr class="tdprinterfriendly">
						<th align="left" width="48%">
							<xsl:value-of select="$LANG//srcname"/>
						</th>
						<th align="left" width="52%">
							<xsl:value-of select="$LANG//dest"/>
						</th>
					</tr>
					</xsl:for-each>
					<xsl:for-each select="SHEETLINKS/SHEETLINK">
					<tr>
						<th align="left" width="48%">
							<xsl:value-of select="$LANG//name"/>:&#160;
							<xsl:value-of select="@SRCNAME"/><br />
							<div class="guid">
								<xsl:value-of select="$LANG//guid"/>:&#160;
								<xsl:value-of select="@SRCGUID"/>
							</div>
						</th>
						<th align="left" width="52%">
							<xsl:value-of select="$LANG//sheet"/>:&#160;
							<xsl:value-of select="@DESTNAME"/><br />
							<div class="guid">
								<xsl:value-of select="$LANG//guid"/>:&#160;
								<xsl:value-of select="@DESTGUID"/>
							</div>
						</th>
					</tr>
					<tr>
					   <th valign="top" height="5" colspan="3">
			
						</th>
					</tr>
					</xsl:for-each>
				</table>
			</th>
		</tr>
		
<!-- Begin Sheet Gauges Links #####################################//-->

		<tr class="thprinterfriendly">
   	   <th valign="top" width="100%" align="left" colspan="3">
				<xsl:value-of select="$LANG//connections"/>:&#160;
			</th>
		</tr>
		<tr>
	      <td valign="top" width="100%" align="left" colspan="3">
			<DIV ID="space">
				<table width="100%" border="1" cellspacing="0" cellpadding="2" align="center" bordercolorlight="#FFFFFF" bordercolordark="#808080" frame="hsides" rules="all">
					<xsl:for-each select="SHEETPVS/GAUGEPVS/SHEETITEM">
					<tr class="tdprinterfriendly">
						<th valign="top" width="20%">
								<xsl:value-of select="@TYPE"/>
						</th>
   				   <th valign="top" width="48%">
							<xsl:value-of select="$LANG//name"/>:&#160;
							<xsl:value-of select="@NAME"/>
						</th>
   				   <th align="left" valign="top" width="32%" class="guid">
							<xsl:value-of select="$LANG//guid"/>:&#160;
							<xsl:value-of select="@GUID"/>
						</th>
					</tr>
					<tr>
   				   <th valign="top" height="5" colspan="3">

						</th>
					</tr>
					<xsl:for-each select="../GAUGEPPITEMS/GAUGEPPITEM/PROCESSMODEL">
					<tr>
						<th valign="top" width="20%">
							<xsl:value-of select="$LANG//connected"/>&#160;
							<xsl:value-of select="$LANG//to"/>&#160;:
						</th>
   				   <th valign="top" width="48%">
							<xsl:value-of select="$LANG//process"/>&#160;:&#160;<xsl:value-of select="@NAME"/>
						</th>
   				   <th align="left" valign="top" width="32%" class="guid">
							<xsl:value-of select="$LANG//guid"/>:&#160;
							<xsl:value-of select="@GUID"/><br />
						</th>
					</tr>
					<xsl:for-each select="../PROCESSITEM">
					<tr>
					<xsl:if test="@NAME = $error">
   				   <th valign="middle" width="20%">
							<font color="#ff0000">
								<xsl:value-of select="$LANG//param"/>:
							</font>  
						</th>
					</xsl:if>	
					<xsl:if test="@NAME != $error">
   				   <th valign="top" width="20%">
							<xsl:value-of select="$LANG//param"/>:
						</th>
					</xsl:if>
					<xsl:if test="@NAME = $error">
   				   <th valign="top" width="48%">
							<font color="#ff0000">
								<xsl:value-of select="@NAME"/>
							</font>  
						</th>	
   				   <th valign="top" width="32%" class="guid">
							<xsl:value-of select="$LANG//guid"/>:&#160;
							<xsl:value-of select="@GUID"/>
						</th>
					</xsl:if>	
					<xsl:if test="@NAME != $error">
   				   <th valign="top" width="48%">
							<xsl:value-of select="@NAME"/><br />  
						</th>
   				   <th valign="top" width="32%" class="guid">
							<xsl:value-of select="$LANG//guid"/>:&#160;
							<xsl:value-of select="@GUID"/>
						</th>
					</xsl:if>
					</tr>
					<tr>
   				   <th valign="top" width="20%">
							<xsl:value-of select="$LANG//addrinfo"/>:
						</th>
   				   <th valign="top" width="80%" colspan="2">
							<xsl:value-of select="@ADDRINFO"/>
						</th>
					</tr>
					<tr>
   				   <th valign="top" width="20%">
							<xsl:value-of select="$LANG//type"/>:
						</th>
   				   <th valign="top" width="80%" colspan="2">
							<xsl:value-of select="@TYPE"/>
						</th>
					</tr>
					<tr>
   				   <th valign="top" width="20%">
							<xsl:value-of select="$LANG//access"/>:
						</th>
   				   <th valign="top" width="80%" colspan="2">
							<xsl:value-of select="@ACCESS"/>
						</th>
					</tr>
					<tr>
   				   <th valign="top" width="20%">
							<xsl:value-of select="$LANG//descr"/>:
						</th>
   				   <th valign="top" width="80%" colspan="2">
							<xsl:value-of select="@DESCR"/>
						</th>
					</tr>
					<tr>
   				   <th valign="top" height="5" colspan="3">

						</th>
					</tr>
					</xsl:for-each>
					</xsl:for-each>
					</xsl:for-each>
				</table>
				</DIV>
				<DIV ID="space"></DIV>
			</td>
		</tr>
	</table>
	<DIV STYLE="page-break-after:always"></DIV>
</DIV>
</xsl:for-each>

<!-- Begin Model Header ##########################################//-->

<DIV ID="bigspace">
	<xsl:for-each select="//REPORT/PROJECT/PROCESSMODELS/PROCESSMODEL">
		<table width="95%" border="1" cellspacing="0" cellpadding="2" align="center" bordercolorlight="#FFFFFF" bordercolordark="#808080" frame="hsides" rules="all">
		<tr class="thprinterfriendly">
			<th align="center" colspan="3">
				<xsl:value-of select="$LANG//process"/>:&#160;
				<xsl:value-of select="@NAME"/>	
			</th>
		</tr>
		<tr class="tdprinterfriendly">
			<th align="center" colspan="3" class="tdprinterfriendly">
				<xsl:value-of select="$LANG//guid"/>:&#160;
				<xsl:value-of select="@GUID"/>
			</th>
		</tr>
		<tr>
   	   <th align="center" colspan="3">
				<xsl:value-of select="$LANG//itemcount"/>:
				<xsl:value-of select="PROCESSITEMS/@COUNT"/>
			</th>
		</tr>
		<tr>
   	   <th align="left" height="5" colspan="3">
			
			</th>
		</tr>
		<xsl:for-each select="PROCESSITEMS/PROCESSITEM">
		<tr>
			<xsl:if test="@NAME = $error">
		   <th align="left" valign="top" width="20%">
				<font color="#ff0000">
					<xsl:value-of select="$LANG//param"/>:
				</font>  
			</th>
		   <th align="left" valign="top" width="80%">
				<xsl:value-of select="@NAME"/>
			</th>	
			</xsl:if>	
			<xsl:if test="@NAME != $error">
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//param"/>:
			</th>
		   <th align="left" valign="top" width="80%">
				<xsl:value-of select="@NAME"/>   
			</th>
			</xsl:if>
		</tr>
		<tr>
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//addrinfo"/>:
			</th>
		   <th align="left" valign="top" width="80%">
				<xsl:value-of select="@ADDRINFO"/>
			</th>
		</tr>
		<tr>
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//type"/>:
			</th>
   	   <th align="left" width="80%">
				<xsl:value-of select="@TYPE"/>
			</th>
		</tr>
		<tr>
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//access"/>:
			</th>
		   <th align="left" valign="top" width="80%">
				<xsl:value-of select="@ACCESS"/>
			</th>
		</tr>
		<tr>
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//scriptname"/>:
			</th>
		   <th align="left" valign="top" width="80%">
				<xsl:value-of select="@SCRIPTNAME"/>
			</th>
		</tr>
		<tr>
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//descr"/>:
			</th>
		   <th align="left" valign="top" width="80%">
				<xsl:value-of select="@DESCR"/>
			</th>
		</tr>
		<tr>
		   <th align="left" valign="top" width="20%">
				<xsl:value-of select="$LANG//guid"/>:
			</th>
		   <th align="left" valign="top" width="80%" class="guid">
				<xsl:value-of select="@GUID"/>
			</th>
		</tr>
		<tr class="subhead">
		   <th align="left" height="5" colspan="2">
		
			</th>
		</tr>
		</xsl:for-each>
	</table>
	</xsl:for-each>
	</DIV>

<br /><div id="copyscreen" align="right"><xsl:value-of select="$LANG//copyright"/>&#160;&#160;&#160;</div>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
