/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swingset3.utilities;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;

public class Utilities {
    private Utilities() {
    }

    public static String getURLFileName(URL uRL) {
        String string = uRL.getPath();
        return string.substring(string.lastIndexOf("/") + 1);
    }

    private static BufferedImage createCompatibleImage(int n, int n2) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n, n2);
    }

    public static BufferedImage createTranslucentImage(int n, int n2) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n, n2, 3);
    }

    public static BufferedImage createGradientImage(int n, int n2, Color color, Color color2) {
        BufferedImage bufferedImage = Utilities.createCompatibleImage(n, n2);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2, false);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage createGradientMask(int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 1.0f), n3 == 0 ? (float)n : 0.0f, n3 == 1 ? (float)n2 : 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
        graphics2D.dispose();
        bufferedImage.flush();
        return bufferedImage;
    }

    public static Color deriveColorAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color deriveColorHSB(Color color, float f, float f2, float f3) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = fArray[0] + f;
        fArray[1] = fArray[1] + f2;
        fArray[2] = fArray[2] + f3;
        return Color.getHSBColor(fArray[0] < 0.0f ? 0.0f : (fArray[0] > 1.0f ? 1.0f : fArray[0]), fArray[1] < 0.0f ? 0.0f : (fArray[1] > 1.0f ? 1.0f : fArray[1]), fArray[2] < 0.0f ? 0.0f : (fArray[2] > 1.0f ? 1.0f : fArray[2]));
    }

    public static String getHTMLColorString(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        return "#" + (string.length() == 1 ? "0" + string : string) + (string2.length() == 1 ? "0" + string2 : string2) + (string3.length() == 1 ? "0" + string3 : string3);
    }

    public static void printColor(String string, Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        System.out.println(string + ": RGB=" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "  " + "HSB=" + String.format("%.0f%n", Float.valueOf(fArray[0] * 360.0f)) + "," + String.format("%.3f%n", Float.valueOf(fArray[1])) + "," + String.format("%.3f%n", Float.valueOf(fArray[2])));
    }
}

