/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs;

import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class BMXValueModel {
    public static final int JOBS_VALUE_FORMAT_EIS1_CONST_LEN = 32;
    public static final int JOBS_VALUE_FORMAT_STRING_LEN = 16;
    public static final int JOBS_VALUE_FORMAT_FLAG_ESCAPE_URL = 1;
    public static final int JOBS_VALUE_FORMAT_FLAG_TRIGGER = 2;
    private byte eis = 1;
    private byte flags;
    private byte trigger_eis14;
    private float factor = 1.0f;
    private float offset = 0.0f;
    private String eis1Text0 = "0";
    private String eis1Text1 = "1";
    private String format = "%f";

    public byte getEis() {
        return this.eis;
    }

    public void setEis(byte by) {
        this.eis = by;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public byte getTrigger_eis14() {
        return this.trigger_eis14;
    }

    public void setTrigger_eis14(byte by) {
        this.trigger_eis14 = by;
    }

    public float getFactor() {
        return this.factor;
    }

    public void setFactor(float f) {
        this.factor = f;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public String getEis1Text0() {
        return this.eis1Text0;
    }

    public void setEis1Text0(String string) {
        this.eis1Text0 = string;
    }

    public String getEis1Text1() {
        return this.eis1Text1;
    }

    public void setEis1Text1(String string) {
        this.eis1Text1 = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public int setBMXJobData(byte[] byArray, int n) {
        int n2 = n;
        this.setEis(byArray[n2++]);
        this.setFlags(byArray[n2++]);
        this.setTrigger_eis14(byArray[n2++]);
        int n3 = n2 + 64;
        switch (this.getEis()) {
            case 1: {
                this.setEis1Text0(new String(byArray, n2, 32).trim());
                this.setEis1Text1(new String(byArray, n2 += 32, 32).trim());
                n2 += 32;
                break;
            }
            case 5: {
                this.setFactor(ByteConv.byte2float(byArray, n2));
                this.setOffset(ByteConv.byte2float(byArray, n2 += 4));
                this.setFormat(new String(byArray, n2 += 4, 16, Charset.forName("ISO-8859-1")).trim());
                n2 += 16;
                break;
            }
            case 4: {
                this.setFormat(new String(byArray, n2, 16).trim());
                n2 += 16;
                break;
            }
            case 9: {
                this.setFactor(ByteConv.byte2float(byArray, n2));
                this.setOffset(ByteConv.byte2float(byArray, n2 += 4));
                this.setFormat(new String(byArray, n2 += 4, 16, Charset.forName("ISO-8859-1")).trim());
                n2 += 16;
                break;
            }
            case 6: {
                this.setFormat(new String(byArray, n2, 16).trim());
                n2 += 16;
                break;
            }
            case 10: {
                this.setFormat(new String(byArray, n2, 16).trim());
                n2 += 16;
                break;
            }
            case 11: {
                this.setFormat(new String(byArray, n2, 16).trim());
                n2 += 16;
                break;
            }
            case 12: {
                this.setFormat(new String(byArray, n2, 16).trim());
                n2 += 16;
            }
        }
        n2 = n3;
        return n2 - n;
    }

    public void getJobData(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byteArrayOutputStream.write(this.getEis());
        byteArrayOutputStream.write(this.getFlags());
        byteArrayOutputStream.write(this.getTrigger_eis14());
        int n = byteArrayOutputStream.size() + 64;
        switch (this.getEis()) {
            case 1: {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getEis1Text0(), 32));
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getEis1Text1(), 32));
                break;
            }
            case 5: {
                byteArrayOutputStream.write(ByteConv.float2byte(this.getFactor()));
                byteArrayOutputStream.write(ByteConv.float2byte(this.getOffset()));
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
                break;
            }
            case 4: {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
                break;
            }
            case 9: {
                byteArrayOutputStream.write(ByteConv.float2byte(this.getFactor()));
                byteArrayOutputStream.write(ByteConv.float2byte(this.getOffset()));
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
                break;
            }
            case 6: {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
                break;
            }
            case 10: {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
                break;
            }
            case 11: {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
                break;
            }
            case 12: {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getFormat(), 16));
            }
        }
        if (byteArrayOutputStream.size() < n) {
            byteArrayOutputStream.write(new byte[n - byteArrayOutputStream.size()]);
        }
    }
}

