/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.cyclicsender;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXCyclicSenderModel
extends BMXJobModel {
    public static final int JOBS_CSENDER_ACTUAL_VERSION = 1;
    public static final int JOBS_CSENDER_VERSION1_JOB_RESERVED = 16;
    public static final int JOBS_CSENDER_VERSION1_EOS_RESERVED = 1;
    public static final int JOBS_CSENDER_OBMAX = 4;
    public static final int JOBS_CSENDER_FLAG_SLOW_START = 1;
    public static final int JOBS_CSENDER_FLAG_EIS1_TOGGLE = 2;
    public static final int JOBS_CSENDER_FLAG_VALUE_READ = 4;
    public static final int JOBS_CSENDER_FLAG_ONE_SHOT_START = 8;
    public static final int JOBS_CSENDER_FLAG_MIN_SATURATE = 16;
    public static final int JOBS_CSENDER_FLAG_MAX_SATURATE = 32;
    public static final int JOBS_CSENDER_FLAG_ONE_SHOT_ENABLE = 64;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objOutput;
    private EIBAddressObject2 objInterval;
    private EIBAddressObject2[] objReserved = new EIBAddressObject2[1];
    private int flags;
    private int version = 1;
    private int eisOutput;
    private int eisInterval;
    private int interval;
    private int minInterval;
    private int maxInterval;
    private byte[] data = new byte[16];

    public BMXCyclicSenderModel(BMXJobData bMXJobData) {
        this.setBMXJobData(bMXJobData);
    }

    public BMXCyclicSenderModel() {
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        this.flags &= ~n;
        if (bl) {
            this.flags |= n;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getEisOutput() {
        return this.eisOutput;
    }

    public void setEisOutput(int n) {
        this.eisOutput = n;
    }

    public int getEisInterval() {
        return this.eisInterval;
    }

    public void setEisInterval(int n) {
        this.eisInterval = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public int getMinInterval() {
        return this.minInterval;
    }

    public void setMinInterval(int n) {
        this.minInterval = n;
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(int n) {
        this.maxInterval = n;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = new byte[16];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjOutput() {
        return this.objOutput;
    }

    public void setObjInterval(EIBAddressObject2 eIBAddressObject2) {
        this.objInterval = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjInterval() {
        return this.objInterval;
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n = 0;
        this.version = byArray[n++];
        this.flags = byArray[n++];
        this.eisOutput = byArray[n++];
        this.eisInterval = byArray[n++];
        this.interval = ByteConv.byte2short(byArray, n);
        this.minInterval = ByteConv.byte2short(byArray, n += 2);
        this.maxInterval = ByteConv.byte2short(byArray, n += 2);
        System.arraycopy(byArray, n += 2, this.data, 0, this.data.length);
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        this.objOutput = bMXJobData.getEIBAddressObject2(1);
        this.objInterval = bMXJobData.getEIBAddressObject2(2);
        for (int i = 0; i < 1; ++i) {
            this.objReserved[i] = bMXJobData.getEIBAddressObject2(3 + i);
        }
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(this.flags);
            byteArrayOutputStream.write(this.eisOutput);
            byteArrayOutputStream.write(this.eisInterval);
            byteArrayOutputStream.write(ByteConv.short2byte(this.interval));
            byteArrayOutputStream.write(ByteConv.short2byte(this.minInterval));
            byteArrayOutputStream.write(ByteConv.short2byte(this.maxInterval));
            byteArrayOutputStream.write(this.data);
            byteArrayOutputStream.write(new byte[16]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_CYCLIC_SENDER, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objOutput);
        bMXJobData.addEIBAddressObject2(this.objInterval);
        for (EIBAddressObject2 eIBAddressObject2 : this.objReserved) {
            bMXJobData.addEIBAddressObject2(eIBAddressObject2);
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Object Enable: " + this.objEnable.getAddressObjectAsString() + string;
        string2 = string2 + "Object Output: " + this.objOutput.getAddressObjectAsString() + string;
        return string2;
    }
}

