/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.rtr;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BMXRTRModel
extends BMXJobModel {
    public static final int JOBS_RTR_CURRENT_VERSION = 1;
    public static final int JOBS_RTR_VERSION1_SETP_RESERVED = 12;
    public static final int JOBS_RTR_VERSION1_INTEMP_RESERVED = 4;
    public static final int JOBS_RTR_VERSION1_JOB_RESERVED = 40;
    public static final int JOBS_RTR_VERSION1_EOS_RESERVED = 6;
    public static final int JOBS_RTR_FLAGS_DUMP = 1;
    public static final int JOBS_RTR_FLAGS_SIMULATE_PT1 = 2;
    public static final int JOBS_RTR_FLAGS_SQUEEZE_TIME = 4;
    public static final int JOBS_RTR_FLAGS_SUMMER_COMPENSATION = 8;
    public static final int JOBS_RTR_FLAGS_WINTER_COMPENSATION = 16;
    public static final int JOBS_RTR_FLAGS_OVERRIDE_ACTUAL_SETPOINT = 32;
    public static final int JOBS_RTR_FLAGS_ALL = 63;
    public static final int JOBS_RTR_MAX_STAGES = 2;
    public static final byte JOBS_RTR_PRESET_MODE_UNDEF = 0;
    public static final byte JOBS_RTR_PRESET_MODE_HEATING = 1;
    public static final byte JOBS_RTR_PRESET_MODE_COOLING = 2;
    public static final byte JOBS_RTR_PRESET_MODE_MANUAL = 3;
    public static final byte JOBS_RTR_PRESET_MODE_AUTO = 4;
    public static final byte OP_MODE_NOTHING = 0;
    public static final byte OP_MODE_COMFORT = 1;
    public static final byte OP_MODE_STANDBY = 2;
    public static final byte OP_MODE_NIGHT_SETBACK = 3;
    public static final byte OP_MODE_ANTIFREEZE = 4;
    public static final byte MODE_OFF = 0;
    public static final byte MODE_NORMAL = 1;
    public static final byte MODE_COMFORT_EXTENSION = 2;
    public static final int TYPE_UNDEF = 0;
    public static final int TYPE_TWO_POSITION = 1;
    public static final int TYPE_PI = 2;
    private short flags;
    private byte version = 1;
    private int presetMode;
    private float setpointBaseInitial = 21.0f;
    private SetpointTemp[] heating = new SetpointTemp[2];
    private SetpointTemp[] cooling = new SetpointTemp[2];
    private InputTemp input1 = new InputTemp();
    private InputTemp input2 = new InputTemp();
    private int[] heatingType = new int[2];
    private int[] coolingType = new int[2];
    private int heatingStages = 1;
    private int coolingStages = 1;
    private int comfortExtensionMins;
    private byte fallbackOpMode;
    private byte fallbackMode;
    private float fallbackHeatingActuatingOff;
    private float fallbackHeatingActuatingError;
    private float fallbackCoolingActuatingOff;
    private float fallbackCoolingActuatingError;
    private float summerCompLowerOutdoorTemp;
    private float summerCompHigherOutdoorTemp;
    private float summerCompLowerOffset;
    private float summerCompHigherOffset;
    private float winterCompLowerOutdoorTemp;
    private float winterCompHigherOutdoorTemp;
    private float winterCompLowerOffset;
    private float winterCompHigherOffset;
    private int[] heatingActuatingEis = new int[2];
    private int[] coolingActuatingEis = new int[2];
    private int[] heatingPwmInterval = new int[]{15, 15};
    private int[] coolingPwmInterval = new int[]{15, 15};
    private int[] heatingPwmInvert = new int[]{15, 15};
    private int[] coolingPwmInvert = new int[]{15, 15};
    private int[] heatingPeriodicInterval = new int[2];
    private int[] coolingPeriodicInterval = new int[2];
    private int setpointPeriodicInterval = 0;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objTempSetpoint;
    private EIBAddressObject2 objTempSetpointBase;
    private EIBAddressObject2 objTempSetpointAdjustment;
    private EIBAddressObject2 objTempCurrent1;
    private EIBAddressObject2 objTempCurrent2;
    private EIBAddressObject2[] objHeatingActuating = new EIBAddressObject2[2];
    private EIBAddressObject2[] objCoolingActuating = new EIBAddressObject2[2];
    private EIBAddressObject2 objWindow;
    private EIBAddressObject2 objOpMode;
    private EIBAddressObject2 objComfortExtension;
    private EIBAddressObject2 objMode;
    private EIBAddressObject2 objStatusEis14;
    private EIBAddressObject2 objOutdoorTemp;
    private EIBAddressObject2 objSummerCompActive;
    private EIBAddressObject2 objWinterCompActive;
    private EIBAddressObject2[] objRESERVED = new EIBAddressObject2[6];

    public BMXRTRModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXRTRModel() {
        for (int i = 0; i < 2; ++i) {
            this.heating[i] = new SetpointTemp();
            this.heating[i].piPropRegion = 1.5f;
            this.heating[i].piResetTime = 100.0f;
            this.cooling[i] = new SetpointTemp();
            this.cooling[i].piPropRegion = 5.0f;
            this.cooling[i].piResetTime = 240.0f;
        }
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short s) {
        this.flags = s;
    }

    public void setSummerCompensationActive(boolean bl) {
        this.flags = (short)(this.flags & 0xFFFFFFF7);
        if (bl) {
            this.flags = (short)(this.flags | 8);
        }
    }

    public boolean getSummerCompenstationActive() {
        return (this.flags & 8) != 0;
    }

    public void setWinterCompensationActive(boolean bl) {
        this.flags = (short)(this.flags & 0xFFFFFFEF);
        if (bl) {
            this.flags = (short)(this.flags | 0x10);
        }
    }

    public boolean getWinterCompenstationActive() {
        return (this.flags & 0x10) != 0;
    }

    public void setOverrideActualSetpoint(boolean bl) {
        this.flags = (short)(this.flags & 0xFFFFFFDF);
        if (bl) {
            this.flags = (short)(this.flags | 0x20);
        }
    }

    public boolean getOverrideActualSetpoint() {
        return (this.flags & 0x20) != 0;
    }

    public int getPresetMode() {
        return this.presetMode;
    }

    public void setPresetMode(int n) {
        this.presetMode = n;
    }

    public float getSetpointBaseInitial() {
        return this.setpointBaseInitial;
    }

    public void setSetpointBaseInitial(float f) {
        this.setpointBaseInitial = f;
    }

    public int getHeatingType(int n) {
        return this.heatingType[n];
    }

    public void setHeatingType(int n, int n2) {
        this.heatingType[n] = n2;
    }

    public int getCoolingType(int n) {
        return this.coolingType[n];
    }

    public void setCoolingType(int n, int n2) {
        this.coolingType[n] = n2;
    }

    public int getHeatingStages() {
        return this.heatingStages;
    }

    public void setHeatingStages(int n) {
        this.heatingStages = n;
    }

    public int getCoolingStages() {
        return this.coolingStages;
    }

    public void setCoolingStages(int n) {
        this.coolingStages = n;
    }

    public int getComfortExtensionMins() {
        return this.comfortExtensionMins;
    }

    public void setComfortExtensionMins(int n) {
        this.comfortExtensionMins = n;
    }

    public byte getFallbackOpMode() {
        return this.fallbackOpMode;
    }

    public void setFallbackOpMode(byte by) {
        this.fallbackOpMode = by;
    }

    public byte getFallbackMode() {
        return this.fallbackMode;
    }

    public void setFallbackMode(byte by) {
        this.fallbackMode = by;
    }

    public float getFallbackHeatingActuatingOff() {
        return this.fallbackHeatingActuatingOff;
    }

    public void setFallbackHeatingActuatingOff(float f) {
        this.fallbackHeatingActuatingOff = f;
    }

    public float getFallbackHeatingActuatingError() {
        return this.fallbackHeatingActuatingError;
    }

    public void setFallbackHeatingActuatingError(float f) {
        this.fallbackHeatingActuatingError = f;
    }

    public float getFallbackCoolingActuatingOff() {
        return this.fallbackCoolingActuatingOff;
    }

    public void setFallbackCoolingActuatingOff(float f) {
        this.fallbackCoolingActuatingOff = f;
    }

    public float getFallbackCoolingActuatingError() {
        return this.fallbackCoolingActuatingError;
    }

    public void setFallbackCoolingActuatingError(float f) {
        this.fallbackCoolingActuatingError = f;
    }

    public float getSummerCompLowerOutdoorTemp() {
        return this.summerCompLowerOutdoorTemp;
    }

    public void setSummerCompLowerOutdoorTemp(float f) {
        this.summerCompLowerOutdoorTemp = f;
    }

    public float getSummerCompHigherOutdoorTemp() {
        return this.summerCompHigherOutdoorTemp;
    }

    public void setSummerCompHigherOutdoorTemp(float f) {
        this.summerCompHigherOutdoorTemp = f;
    }

    public float getSummerCompLowerOffset() {
        return this.summerCompLowerOffset;
    }

    public void setSummerCompLowerOffset(float f) {
        this.summerCompLowerOffset = f;
    }

    public float getSummerCompHigherOffset() {
        return this.summerCompHigherOffset;
    }

    public void setSummerCompHigherOffset(float f) {
        this.summerCompHigherOffset = f;
    }

    public float getWinterCompLowerOutdoorTemp() {
        return this.winterCompLowerOutdoorTemp;
    }

    public void setWinterCompLowerOutdoorTemp(float f) {
        this.winterCompLowerOutdoorTemp = f;
    }

    public float getWinterCompHigherOutdoorTemp() {
        return this.winterCompHigherOutdoorTemp;
    }

    public void setWinterCompHigherOutdoorTemp(float f) {
        this.winterCompHigherOutdoorTemp = f;
    }

    public float getWinterCompLowerOffset() {
        return this.winterCompLowerOffset;
    }

    public void setWinterCompLowerOffset(float f) {
        this.winterCompLowerOffset = f;
    }

    public float getWinterCompHigherOffset() {
        return this.winterCompHigherOffset;
    }

    public void setWinterCompHigherOffset(float f) {
        this.winterCompHigherOffset = f;
    }

    public int getHeatingActuatingEis(int n) {
        return this.heatingActuatingEis[n];
    }

    public void setHeatingActuatingEis(int n, int n2) {
        this.heatingActuatingEis[n] = n2;
    }

    public int getCoolingActuatingEis(int n) {
        return this.coolingActuatingEis[n];
    }

    public void setCoolingActuatingEis(int n, int n2) {
        this.coolingActuatingEis[n] = n2;
    }

    public int getHeatingPwmInterval(int n) {
        return this.heatingPwmInterval[n];
    }

    public void setHeatingPwmInterval(int n, int n2) {
        this.heatingPwmInterval[n] = n2;
    }

    public boolean getHeatingPwmInvert(int n) {
        return this.heatingPwmInvert[n] != 0;
    }

    public void setHeatingPwmInvert(int n, boolean bl) {
        this.heatingPwmInvert[n] = bl ? 1 : 0;
    }

    public int getCoolingPwmInterval(int n) {
        return this.coolingPwmInterval[n];
    }

    public void setCoolingPwmInterval(int n, int n2) {
        this.coolingPwmInterval[n] = n2;
    }

    public boolean getCoolingPwmInvert(int n) {
        return this.coolingPwmInvert[n] != 0;
    }

    public void setCoolingPwmInvert(int n, boolean bl) {
        this.coolingPwmInvert[n] = bl ? 1 : 0;
    }

    public int getHeatingPeriodicInterval(int n) {
        return this.heatingPeriodicInterval[n];
    }

    public void setHeatingPeriodicInterval(int n, int n2) {
        this.heatingPeriodicInterval[n] = n2;
    }

    public int getCoolingPeriodicInterval(int n) {
        return this.coolingPeriodicInterval[n];
    }

    public void setCoolingPeriodicInterval(int n, int n2) {
        this.coolingPeriodicInterval[n] = n2;
    }

    public int getSetpointPeriodicInterval() {
        return this.setpointPeriodicInterval;
    }

    public void setSetpointPeriodicInterval(int n) {
        this.setpointPeriodicInterval = n;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempSetpoint() {
        return this.objTempSetpoint;
    }

    public void setObjTempSetpoint(EIBAddressObject2 eIBAddressObject2) {
        this.objTempSetpoint = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempSetpointBase() {
        return this.objTempSetpointBase;
    }

    public void setObjTempSetpointBase(EIBAddressObject2 eIBAddressObject2) {
        this.objTempSetpointBase = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempSetpointAdjustment() {
        return this.objTempSetpointAdjustment;
    }

    public void setObjTempSetpointAdjustment(EIBAddressObject2 eIBAddressObject2) {
        this.objTempSetpointAdjustment = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempCurrent1() {
        return this.objTempCurrent1;
    }

    public void setObjTempCurrent1(EIBAddressObject2 eIBAddressObject2) {
        this.objTempCurrent1 = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempCurrent2() {
        return this.objTempCurrent2;
    }

    public void setObjTempCurrent2(EIBAddressObject2 eIBAddressObject2) {
        this.objTempCurrent2 = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjHeatingActuating(int n) {
        return this.objHeatingActuating[n];
    }

    public void setObjHeatingActuating(int n, EIBAddressObject2 eIBAddressObject2) {
        this.objHeatingActuating[n] = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjCoolingActuating(int n) {
        return this.objCoolingActuating[n];
    }

    public void setObjCoolingActuating(int n, EIBAddressObject2 eIBAddressObject2) {
        this.objCoolingActuating[n] = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjWindow() {
        return this.objWindow;
    }

    public void setObjWindow(EIBAddressObject2 eIBAddressObject2) {
        this.objWindow = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjOpMode() {
        return this.objOpMode;
    }

    public void setObjOpMode(EIBAddressObject2 eIBAddressObject2) {
        this.objOpMode = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjComfortExtension() {
        return this.objComfortExtension;
    }

    public void setObjComfortExtension(EIBAddressObject2 eIBAddressObject2) {
        this.objComfortExtension = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjMode() {
        return this.objMode;
    }

    public void setObjMode(EIBAddressObject2 eIBAddressObject2) {
        this.objMode = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjOutdoorTemp() {
        return this.objOutdoorTemp;
    }

    public void setObjOutdoorTemp(EIBAddressObject2 eIBAddressObject2) {
        this.objOutdoorTemp = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjSummerCompActive() {
        return this.objSummerCompActive;
    }

    public void setObjSummerCompActive(EIBAddressObject2 eIBAddressObject2) {
        this.objSummerCompActive = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjWinterCompActive() {
        return this.objWinterCompActive;
    }

    public void setObjWinterCompActive(EIBAddressObject2 eIBAddressObject2) {
        this.objWinterCompActive = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStatusEis14() {
        return this.objStatusEis14;
    }

    public void setObjStatusEis14(EIBAddressObject2 eIBAddressObject2) {
        this.objStatusEis14 = eIBAddressObject2;
    }

    public byte getVersion() {
        return this.version;
    }

    public SetpointTemp getHeating(int n) {
        return this.heating[n];
    }

    public SetpointTemp getCooling(int n) {
        return this.cooling[n];
    }

    public InputTemp getInput1() {
        return this.input1;
    }

    public InputTemp getInput2() {
        return this.input2;
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        int n2;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n3 = 0;
        this.flags = (short)(ByteConv.byte2short(byArray, n3) & 0xFFFF);
        n3 += 2;
        this.version = byArray[n3++];
        this.presetMode = byArray[n3++];
        this.setpointBaseInitial = ByteConv.byte2float(byArray, n3);
        n3 += 4;
        for (n2 = 0; n2 < 2; ++n2) {
            n3 = this.heating[n2].setData(byArray, n3);
        }
        for (n2 = 0; n2 < 2; ++n2) {
            n3 = this.cooling[n2].setData(byArray, n3);
        }
        n3 = this.input1.setData(byArray, n3);
        n3 = this.input2.setData(byArray, n3);
        for (n2 = 0; n2 < 2; ++n2) {
            this.heatingType[n2] = byArray[n3++] & 0xFF;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            this.coolingType[n2] = byArray[n3++] & 0xFF;
        }
        this.heatingStages = byArray[n3++];
        this.coolingStages = byArray[n3++];
        this.comfortExtensionMins = ByteConv.byte2short(byArray, n3);
        n3 += 2;
        this.fallbackOpMode = byArray[n3++];
        this.fallbackMode = byArray[n3++];
        this.fallbackHeatingActuatingOff = ByteConv.byte2float(byArray, n3);
        this.fallbackHeatingActuatingError = ByteConv.byte2float(byArray, n3 += 4);
        this.fallbackCoolingActuatingOff = ByteConv.byte2float(byArray, n3 += 4);
        this.fallbackCoolingActuatingError = ByteConv.byte2float(byArray, n3 += 4);
        this.summerCompLowerOutdoorTemp = ByteConv.byte2float(byArray, n3 += 4);
        this.summerCompHigherOutdoorTemp = ByteConv.byte2float(byArray, n3 += 4);
        this.summerCompLowerOffset = ByteConv.byte2float(byArray, n3 += 4);
        this.summerCompHigherOffset = ByteConv.byte2float(byArray, n3 += 4);
        this.winterCompLowerOutdoorTemp = ByteConv.byte2float(byArray, n3 += 4);
        this.winterCompHigherOutdoorTemp = ByteConv.byte2float(byArray, n3 += 4);
        this.winterCompLowerOffset = ByteConv.byte2float(byArray, n3 += 4);
        this.winterCompHigherOffset = ByteConv.byte2float(byArray, n3 += 4);
        n3 += 4;
        this.heatingActuatingEis[0] = byArray[n3++] & 0xFF;
        this.heatingActuatingEis[1] = byArray[n3++] & 0xFF;
        this.coolingActuatingEis[0] = byArray[n3++] & 0xFF;
        this.coolingActuatingEis[1] = byArray[n3++] & 0xFF;
        this.heatingPwmInterval[0] = byArray[n3++] & 0xFF;
        this.heatingPwmInterval[1] = byArray[n3++] & 0xFF;
        this.coolingPwmInterval[0] = byArray[n3++] & 0xFF;
        this.coolingPwmInterval[1] = byArray[n3++] & 0xFF;
        this.heatingPwmInvert[0] = byArray[n3++] & 0xFF;
        this.heatingPwmInvert[1] = byArray[n3++] & 0xFF;
        this.coolingPwmInvert[0] = byArray[n3++] & 0xFF;
        this.coolingPwmInvert[1] = byArray[n3++] & 0xFF;
        this.heatingPeriodicInterval[0] = byArray[n3++] & 0xFF;
        this.heatingPeriodicInterval[1] = byArray[n3++] & 0xFF;
        this.coolingPeriodicInterval[0] = byArray[n3++] & 0xFF;
        this.coolingPeriodicInterval[1] = byArray[n3++] & 0xFF;
        this.setpointPeriodicInterval = byArray[n3++] & 0xFF;
        n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempSetpoint = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempSetpointBase = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempSetpointAdjustment = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempCurrent1 = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempCurrent2 = bMXJobData.getEIBAddressObject2(n2++);
        for (n = 0; n < 2; ++n) {
            this.objHeatingActuating[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        for (n = 0; n < 2; ++n) {
            this.objCoolingActuating[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        this.objWindow = bMXJobData.getEIBAddressObject2(n2++);
        this.objOpMode = bMXJobData.getEIBAddressObject2(n2++);
        this.objComfortExtension = bMXJobData.getEIBAddressObject2(n2++);
        this.objMode = bMXJobData.getEIBAddressObject2(n2++);
        this.objStatusEis14 = bMXJobData.getEIBAddressObject2(n2++);
        this.objOutdoorTemp = bMXJobData.getEIBAddressObject2(n2++);
        this.objSummerCompActive = bMXJobData.getEIBAddressObject2(n2++);
        this.objWinterCompActive = bMXJobData.getEIBAddressObject2(n2++);
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byteArrayOutputStream.write(ByteConv.short2byte(new byte[2], 0, this.flags & 0xFFFF));
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(this.presetMode);
            byteArrayOutputStream.write(ByteConv.float2byte(this.setpointBaseInitial));
            for (n2 = 0; n2 < 2; ++n2) {
                this.heating[n2].getData(byteArrayOutputStream);
            }
            for (n2 = 0; n2 < 2; ++n2) {
                this.cooling[n2].getData(byteArrayOutputStream);
            }
            this.input1.getData(byteArrayOutputStream);
            this.input2.getData(byteArrayOutputStream);
            for (n2 = 0; n2 < 2; ++n2) {
                byteArrayOutputStream.write(this.heatingType[n2]);
            }
            for (n2 = 0; n2 < 2; ++n2) {
                byteArrayOutputStream.write(this.coolingType[n2]);
            }
            byteArrayOutputStream.write(this.heatingStages);
            byteArrayOutputStream.write(this.coolingStages);
            byteArrayOutputStream.write(ByteConv.short2byte(this.comfortExtensionMins));
            byteArrayOutputStream.write(this.fallbackOpMode);
            byteArrayOutputStream.write(this.fallbackMode);
            byteArrayOutputStream.write(ByteConv.float2byte(this.fallbackHeatingActuatingOff));
            byteArrayOutputStream.write(ByteConv.float2byte(this.fallbackHeatingActuatingError));
            byteArrayOutputStream.write(ByteConv.float2byte(this.fallbackCoolingActuatingOff));
            byteArrayOutputStream.write(ByteConv.float2byte(this.fallbackCoolingActuatingError));
            byteArrayOutputStream.write(ByteConv.float2byte(this.summerCompLowerOutdoorTemp));
            byteArrayOutputStream.write(ByteConv.float2byte(this.summerCompHigherOutdoorTemp));
            byteArrayOutputStream.write(ByteConv.float2byte(this.summerCompLowerOffset));
            byteArrayOutputStream.write(ByteConv.float2byte(this.summerCompHigherOffset));
            byteArrayOutputStream.write(ByteConv.float2byte(this.winterCompLowerOutdoorTemp));
            byteArrayOutputStream.write(ByteConv.float2byte(this.winterCompHigherOutdoorTemp));
            byteArrayOutputStream.write(ByteConv.float2byte(this.winterCompLowerOffset));
            byteArrayOutputStream.write(ByteConv.float2byte(this.winterCompHigherOffset));
            byteArrayOutputStream.write(this.heatingActuatingEis[0]);
            byteArrayOutputStream.write(this.heatingActuatingEis[1]);
            byteArrayOutputStream.write(this.coolingActuatingEis[0]);
            byteArrayOutputStream.write(this.coolingActuatingEis[1]);
            byteArrayOutputStream.write(this.heatingPwmInterval[0]);
            byteArrayOutputStream.write(this.heatingPwmInterval[1]);
            byteArrayOutputStream.write(this.coolingPwmInterval[0]);
            byteArrayOutputStream.write(this.coolingPwmInterval[1]);
            byteArrayOutputStream.write(this.heatingPwmInvert[0]);
            byteArrayOutputStream.write(this.heatingPwmInvert[1]);
            byteArrayOutputStream.write(this.coolingPwmInvert[0]);
            byteArrayOutputStream.write(this.coolingPwmInvert[1]);
            byteArrayOutputStream.write(this.heatingPeriodicInterval[0]);
            byteArrayOutputStream.write(this.heatingPeriodicInterval[1]);
            byteArrayOutputStream.write(this.coolingPeriodicInterval[0]);
            byteArrayOutputStream.write(this.coolingPeriodicInterval[1]);
            byteArrayOutputStream.write(this.setpointPeriodicInterval);
            byteArrayOutputStream.write(new byte[40]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        System.out.println("parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_RTR, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objTempSetpoint);
        bMXJobData.addEIBAddressObject2(this.objTempSetpointBase);
        bMXJobData.addEIBAddressObject2(this.objTempSetpointAdjustment);
        bMXJobData.addEIBAddressObject2(this.objTempCurrent1);
        bMXJobData.addEIBAddressObject2(this.objTempCurrent2);
        for (n = 0; n < 2; ++n) {
            bMXJobData.addEIBAddressObject2(this.objHeatingActuating[n]);
        }
        for (n = 0; n < 2; ++n) {
            bMXJobData.addEIBAddressObject2(this.objCoolingActuating[n]);
        }
        bMXJobData.addEIBAddressObject2(this.objWindow);
        bMXJobData.addEIBAddressObject2(this.objOpMode);
        bMXJobData.addEIBAddressObject2(this.objComfortExtension);
        bMXJobData.addEIBAddressObject2(this.objMode);
        bMXJobData.addEIBAddressObject2(this.objStatusEis14);
        bMXJobData.addEIBAddressObject2(this.objOutdoorTemp);
        bMXJobData.addEIBAddressObject2(this.objSummerCompActive);
        bMXJobData.addEIBAddressObject2(this.objWinterCompActive);
        for (n = 0; n < this.objRESERVED.length; ++n) {
            bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        }
        return bMXJobData;
    }

    public class SetpointTemp {
        private float offsetComfort;
        private float offsetStandby;
        private float offsetNight;
        private float frostHeat;
        private float tempHysteresis;
        private float adjustmentStep = 0.5f;
        private float piPropRegion;
        private float piResetTime;

        private SetpointTemp() {
        }

        int setData(byte[] byArray, int n) {
            this.offsetComfort = ByteConv.byte2float(byArray, n);
            this.offsetStandby = ByteConv.byte2float(byArray, n += 4);
            this.offsetNight = ByteConv.byte2float(byArray, n += 4);
            this.frostHeat = ByteConv.byte2float(byArray, n += 4);
            this.tempHysteresis = ByteConv.byte2float(byArray, n += 4);
            this.adjustmentStep = ByteConv.byte2float(byArray, n += 4);
            this.piPropRegion = ByteConv.byte2float(byArray, n += 4);
            this.piResetTime = ByteConv.byte2float(byArray, n += 4);
            n += 4;
            return n += 12;
        }

        void getData(OutputStream outputStream) throws IOException {
            outputStream.write(ByteConv.float2byte(this.offsetComfort));
            outputStream.write(ByteConv.float2byte(this.offsetStandby));
            outputStream.write(ByteConv.float2byte(this.offsetNight));
            outputStream.write(ByteConv.float2byte(this.frostHeat));
            outputStream.write(ByteConv.float2byte(this.tempHysteresis));
            outputStream.write(ByteConv.float2byte(this.adjustmentStep));
            outputStream.write(ByteConv.float2byte(this.piPropRegion));
            outputStream.write(ByteConv.float2byte(this.piResetTime));
            outputStream.write(new byte[12]);
        }

        public float getOffsetComfort() {
            return this.offsetComfort;
        }

        public void setOffsetComfort(float f) {
            this.offsetComfort = f;
        }

        public float getOffsetStandby() {
            return this.offsetStandby;
        }

        public void setOffsetStandby(float f) {
            this.offsetStandby = f;
        }

        public float getOffsetNight() {
            return this.offsetNight;
        }

        public void setOffsetNight(float f) {
            this.offsetNight = f;
        }

        public float getFrostHeat() {
            return this.frostHeat;
        }

        public void setFrostHeat(float f) {
            this.frostHeat = f;
        }

        public float getTempHysteresis() {
            return this.tempHysteresis;
        }

        public void setTempHysteresis(float f) {
            this.tempHysteresis = f;
        }

        public float getAdjustmentStep() {
            return this.adjustmentStep;
        }

        public void setAdjustmentStep(float f) {
            this.adjustmentStep = f;
        }

        public float getPiPropRegion() {
            return this.piPropRegion;
        }

        public void setPiPropRegion(float f) {
            this.piPropRegion = f;
        }

        public float getPiResetTime() {
            return this.piResetTime;
        }

        public void setPiResetTime(float f) {
            this.piResetTime = f;
        }
    }

    public class InputTemp {
        private float offset;
        private float weight;
        private int timeoutMins;

        private InputTemp() {
        }

        int setData(byte[] byArray, int n) {
            this.offset = ByteConv.byte2float(byArray, n);
            this.weight = ByteConv.byte2float(byArray, n += 4);
            this.timeoutMins = ByteConv.byte2short(byArray, n += 4);
            n += 2;
            return n += 4;
        }

        void getData(OutputStream outputStream) throws IOException {
            outputStream.write(ByteConv.float2byte(this.offset));
            outputStream.write(ByteConv.float2byte(this.weight));
            outputStream.write(ByteConv.short2byte(this.timeoutMins));
            outputStream.write(new byte[4]);
        }

        public float getOffset() {
            return this.offset;
        }

        public void setOffset(float f) {
            this.offset = f;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float f) {
            this.weight = f;
        }

        public int getTimeoutMins() {
            return this.timeoutMins;
        }

        public void setTimeoutMins(int n) {
            this.timeoutMins = n;
        }
    }
}

