/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.eis;

import de.babtec.globals.knx.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_Eis9
extends DataType<Float> {
    public static final float MIN_VALUE = -3.4028235E38f;
    public static final float MAX_VALUE = Float.MAX_VALUE;

    public DT_Eis9() {
        super(10000090, "EIS 9 (4 Byte FP)");
    }

    protected DT_Eis9(int n, String string) {
        super(n, string);
    }

    @Override
    public Double getDoubleValue(Float f) {
        return f.doubleValue();
    }

    @Override
    public Float getDataValue(Double d) {
        return Float.valueOf(d.floatValue());
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(Float.MAX_VALUE);
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(-3.4028235E38f);
    }

    @Override
    public Float getValueInRange(Float f, double d, double d2) {
        return super.getValueInRange(f, d, d2, -3.4028235E38f, Float.MAX_VALUE);
    }

    @Override
    public boolean isInRange(Float f, double d, double d2) {
        return super.isInRange(f, d, d2, -3.4028235E38f, Float.MAX_VALUE);
    }

    @Override
    public Float getValueInThisRange(Float f, double d, double d2) {
        float f2 = (float)(-3.4028234663852886E38 < d ? d : -3.4028234663852886E38);
        float f3 = (float)(3.4028234663852886E38 > d2 ? d2 : 3.4028234663852886E38);
        return Float.valueOf(f.floatValue() < f2 ? f2 : (f.floatValue() > f3 ? f3 : f.floatValue()));
    }

    @Override
    public boolean isInThisRange(Float f, double d, double d2) {
        return (double)f.floatValue() >= Math.max(-3.4028234663852886E38, d) && (double)f.floatValue() <= Math.min(3.4028234663852886E38, d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Float f) {
        int n = Float.floatToIntBits(f.floatValue());
        return new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
    }

    @Override
    public byte[] getData(Float f, double d, double d2) {
        return this.getData(Float.valueOf((float)(((double)f.floatValue() - d2) / d)));
    }

    @Override
    public Float getValue(byte[] byArray) {
        int n = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
        return Float.valueOf(Float.intBitsToFloat(n));
    }

    @Override
    public Float getValue(byte[] byArray, double d, double d2) {
        return Float.valueOf(Double.valueOf((double)this.getValue(byArray).floatValue() * d + d2).floatValue());
    }

    @Override
    public String getValueAsString(Float f) {
        return f.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%f";
    }

    @Override
    public String formatValue(Float f, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(f);
    }

    @Override
    public Float parseValue(String string) throws Exception {
        return Float.valueOf(Float.parseFloat(string));
    }

    @Override
    public Float parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return Float.valueOf(new DecimalFormat(string2).parse(string).floatValue());
            }
        }
        catch (ParseException parseException) {
            return Float.valueOf(Float.parseFloat(string));
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 8;
    }

    @Override
    public byte getBmxIndex() {
        return 9;
    }
}

