/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooser
extends JDialog
implements ActionListener {
    private String[] strings = new String[]{"Font Chooser", "Font", "Size", "Bold", "Italic", "Preview", "OK", "Cancel", "Reset"};
    private GridBagLayout gbl = new GridBagLayout();
    private Font oldFont;
    private Font font;
    private JLabel label = new JLabel("aA bB cC dD", 0);
    private JComboBox fontNames;
    private JSpinner size = new JSpinner(new SpinnerNumberModel(15, 5, 72, 1));
    private JCheckBox bold = new JCheckBox();
    private JCheckBox italic = new JCheckBox();

    public FontChooser(Frame frame, String[] stringArray, int n, ActionListener actionListener) throws HeadlessException {
        super(frame, true);
        this.strings = stringArray;
        this.buildInterface(actionListener);
        ((SpinnerNumberModel)this.size.getModel()).setMaximum(Integer.valueOf(n));
    }

    public FontChooser(Frame frame, ActionListener actionListener) throws HeadlessException {
        super(frame, true);
        this.buildInterface(actionListener);
    }

    public void buildInterface(ActionListener actionListener) {
        int n;
        this.setTitle(this.strings[0]);
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout(this.gbl);
        this.gbl.columnWeights = new double[8];
        this.gbl.rowWeights = new double[4];
        for (n = 0; n < this.gbl.columnWeights.length; ++n) {
            this.gbl.columnWeights[n] = 1.0;
        }
        for (n = 0; n < this.gbl.rowWeights.length; ++n) {
            this.gbl.rowWeights[n] = 1.0;
        }
        container.add((Component)new JLabel(this.strings[1] + ":"), this.getGbc(2, 0, 2, 1, 0.1, 1.0));
        this.fontNames = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.fontNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FontChooser.this.font = new Font(FontChooser.this.fontNames.getSelectedItem().toString(), FontChooser.this.font.getStyle(), FontChooser.this.font.getSize());
                FontChooser.this.label.setFont(FontChooser.this.font);
            }
        });
        container.add((Component)this.fontNames, this.getGbc(4, 0, 2, 1, 2.0, 1.0));
        container.add((Component)new JLabel(this.strings[2] + ":"), this.getGbc(2, 1, 2, 1, 0.1, 1.0));
        this.size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FontChooser.this.font = new Font(FontChooser.this.font.getFamily(), FontChooser.this.font.getStyle(), Integer.parseInt(FontChooser.this.size.getValue().toString()));
                FontChooser.this.label.setFont(FontChooser.this.font);
            }
        });
        container.add((Component)this.size, this.getGbc(4, 1, 2, 1, 2.0, 1.0));
        this.bold.setText(this.strings[3]);
        this.bold.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = 0;
                if (FontChooser.this.bold.isSelected()) {
                    ++n;
                }
                if (FontChooser.this.italic.isSelected()) {
                    n += 2;
                }
                FontChooser.this.font = new Font(FontChooser.this.font.getFamily(), n, FontChooser.this.font.getSize());
                FontChooser.this.label.setFont(FontChooser.this.font);
            }
        });
        container.add((Component)this.bold, this.getGbc(3, 2, 1, 1, 2.0, 1.0));
        this.italic.setText(this.strings[4]);
        this.italic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = 0;
                if (FontChooser.this.bold.isSelected()) {
                    ++n;
                }
                if (FontChooser.this.italic.isSelected()) {
                    n += 2;
                }
                FontChooser.this.font = new Font(FontChooser.this.font.getFamily(), n, FontChooser.this.font.getSize());
                FontChooser.this.label.setFont(FontChooser.this.font);
            }
        });
        container.add((Component)this.italic, this.getGbc(5, 2, 1, 1, 2.0, 1.0));
        this.oldFont = this.font = new Font(this.fontNames.getSelectedItem().toString(), 0, Integer.parseInt(this.size.getValue().toString()));
        this.label.setFont(this.font);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(" " + this.strings[5] + " "));
        jPanel.setPreferredSize(new Dimension(350, 80));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.label, "Center");
        container.add((Component)jPanel, this.getGbc(0, 3, 8, 1, 1.0, 1.0));
        JButton jButton = new JButton(this.strings[6]);
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("OK");
        container.add((Component)jButton, this.getGbc(1, 4, 2, 1, 1.0, 1.0));
        jButton = new JButton(this.strings[7]);
        jButton.addActionListener(this);
        jButton.setActionCommand("CANCEL");
        container.add((Component)jButton, this.getGbc(3, 4, 2, 1, 1.0, 1.0));
        jButton = new JButton(this.strings[8]);
        jButton.addActionListener(this);
        jButton.setActionCommand("RESET");
        container.add((Component)jButton, this.getGbc(5, 4, 2, 1, 1.0, 1.0));
        this.pack();
    }

    private void setFontProperties(Font font) {
        this.fontNames.setSelectedItem(font.getFamily());
        this.size.setValue(new Integer(font.getSize()));
        if (font.isBold()) {
            this.bold.setSelected(true);
        } else {
            this.bold.setSelected(false);
        }
        if (font.isItalic()) {
            this.italic.setSelected(true);
        } else {
            this.italic.setSelected(false);
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.oldFont = font;
        this.label.setFont(font);
        this.setFontProperties(font);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CANCEL")) {
            this.dispose();
        } else if (string.equals("RESET")) {
            this.font = this.oldFont;
            this.setFontProperties(this.font);
        }
    }

    private GridBagConstraints getGbc(int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 1, 1);
        return gridBagConstraints;
    }
}

