/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.backup;

import de.eibport.components.backup.BackupProcessListener;
import de.eibport.net.ExtHostInformation;
import de.eibport.net.sftp.FiProgressMonitor;
import de.eibport.net.sftp.FileInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.security.Key;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class BackupProcess {
    public static final int MASK_CONFIGURATION = 1;
    public static final int MASK_JOBS = 2;
    public static final int MASK_VISUALISATION = 4;
    public static final int MASK_RAP = 8;
    public static final int MASK_HISTORY = 16;
    public static final int MASK_STATES = 32;
    public static final int MASK_VPN = 64;
    public static final int MASK_DO_NOT_USE = 128;
    public static final int MASK_ALL = 127;
    public static final String BASIC_PATH = "/config/";
    public static final String MAIN_APPL = "yabus";
    public static final String FILE_BACKUP = "/config/backup.xml.zip";
    public static String BACKUP_FILE_EXTENSION = ".icb";
    public static String BACKUP_DOC_ROOT = "icBackup";
    public static String BACKUP_DOC_VERSION = "icBackupVersion";
    private byte[] iv_idx;
    private byte[] key_idx;
    private FileInterface fileInterface;
    private Document backupDoc;
    private ExtHostInformation hi;

    public BackupProcess(ExtHostInformation extHostInformation, FileInterface fileInterface) {
        this.fileInterface = fileInterface;
        this.hi = extHostInformation;
        try {
            InputStream inputStream = fileInterface.readFromFile(FILE_BACKUP, true);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            if (zipInputStream != null) {
                zipInputStream.getNextEntry();
                this.backupDoc = new SAXBuilder().build(zipInputStream);
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BackupProcess setCipherProps(byte[] byArray, byte[] byArray2) {
        this.iv_idx = byArray;
        this.key_idx = byArray2;
        return this;
    }

    public BackupProcess setBackupProps(String string, String string2, String string3) {
        BACKUP_FILE_EXTENSION = string;
        BACKUP_DOC_ROOT = string2;
        BACKUP_DOC_VERSION = string3;
        return this;
    }

    public void startBackup(final int n, final File file, final String string, final BackupProcessListener backupProcessListener) {
        new Thread(){

            @Override
            public void run() {
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    Object object;
                    Object object22;
                    backupProcessListener.backupStarted();
                    int n3 = 0;
                    Element element = new Element(BACKUP_DOC_ROOT).setAttribute(BACKUP_DOC_VERSION, BackupProcess.this.backupDoc.getRootElement().getAttributeValue("version")).setAttribute("ep_version", BackupProcess.this.hi.getFwVersion()).setAttribute("mask", Integer.toString(n));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                    for (Object object22 : BackupProcess.this.backupDoc.getRootElement().getChildren("category")) {
                        Object object3;
                        int n2 = ((Element)object22).getAttribute("mask").getIntValue();
                        if ((n2 & n) != n2) continue;
                        arrayList.clear();
                        for (Element element2 : ((Element)object22).getChildren("file")) {
                            object3 = element2.getAttributeValue("doBackup");
                            if (object3 != null && !Boolean.parseBoolean((String)object3) || !BackupProcess.this.fileInterface.fileExists(element2.getText())) continue;
                            arrayList.add(element2.getText());
                        }
                        for (Element element2 : ((Element)object22).getChildren("directory")) {
                            object3 = element2.getAttributeValue("doBackup");
                            if (object3 != null && !Boolean.parseBoolean((String)object3)) continue;
                            BackupProcess.this.backupDirectory(element2.getText(), element2.getAttribute("recursive").getBooleanValue(), arrayList);
                        }
                        backupProcessListener.backupGroupChanged(((Element)object22).getAttributeValue("title"), arrayList.size());
                        object = new Element("category").setAttribute("title", ((Element)object22).getAttributeValue("title")).setAttribute("fileCount", Integer.toString(arrayList.size()));
                        n3 += arrayList.size();
                        element.addContent((Content)object);
                        for (int i = 0; i < arrayList.size(); ++i) {
                            backupProcessListener.backupGroupIncrement();
                            object3 = new Element("file");
                            ((Element)object3).setAttribute("filename", (String)arrayList.get(i));
                            ((Element)object).addContent((Content)object3);
                            BackupProcess.this.backupFile((Element)object3, (String)arrayList.get(i), zipOutputStream, new FiProgressMonitor(){
                                long done = 0L;
                                long max = 0L;

                                @Override
                                public void init(int n, String string, String string2, long l) {
                                    this.max = l;
                                    this.done = 0L;
                                }

                                @Override
                                public boolean count(long l) {
                                    this.done += l;
                                    backupProcessListener.backupFileProgress(this.done, this.max);
                                    return true;
                                }

                                @Override
                                public void end() {
                                }
                            });
                        }
                    }
                    element.setAttribute("fileCount", Integer.toString(n3));
                    zipOutputStream.close();
                    file.getParentFile().mkdirs();
                    ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file));
                    zipOutputStream2.setLevel(0);
                    zipOutputStream2.putNextEntry(new ZipEntry("data"));
                    object22 = new CipherOutputStream(zipOutputStream2, BackupProcess.this.getCipher(1));
                    ((CipherOutputStream)object22).write(byteArrayOutputStream.toByteArray());
                    zipOutputStream2.closeEntry();
                    zipOutputStream2.putNextEntry(new ZipEntry("index.xml"));
                    XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
                    xMLOutputter.output(element, (OutputStream)new CipherOutputStream(zipOutputStream2, BackupProcess.this.getCipher(1)));
                    zipOutputStream2.closeEntry();
                    object = new Element("comment");
                    ((Element)object).addContent(new Element("date").setText(Long.toString(System.currentTimeMillis())));
                    ((Element)object).addContent(new Element("ep_version").setText(BackupProcess.this.hi.getFwVersion()));
                    ((Element)object).addContent(new Element("ep_name").setText(BackupProcess.this.hi.getEpName()));
                    if (string == null) {
                        ((Element)object).addContent(new Element("text"));
                    } else {
                        ((Element)object).addContent(new Element("text").setText(string));
                    }
                    zipOutputStream2.putNextEntry(new ZipEntry("comment.xml"));
                    xMLOutputter.output((Element)object, (OutputStream)zipOutputStream2);
                    zipOutputStream2.closeEntry();
                    zipOutputStream2.close();
                    if (!BackupProcess.this.validateBackup(file)) {
                        backupProcessListener.backupFailed(2);
                    }
                }
                catch (JDOMException jDOMException) {
                    jDOMException.printStackTrace();
                    backupProcessListener.backupFailed(1);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    backupProcessListener.backupFailed(3);
                }
                backupProcessListener.backupFinished();
            }
        }.start();
    }

    private boolean validateBackup(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("data");
            zipEntry = zipFile.getEntry("index.xml");
            zipFile.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void backupFile(Element element, String string, ZipOutputStream zipOutputStream, FiProgressMonitor fiProgressMonitor) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(string));
        this.fileInterface.copy(string, zipOutputStream, fiProgressMonitor);
        element.setAttribute("group", Integer.toString(this.fileInterface.getGrp(string)));
        element.setAttribute("owner", Integer.toString(this.fileInterface.getOwn(string)));
        element.setAttribute("permissions", Integer.toString(this.fileInterface.getPermissions(string)));
        zipOutputStream.closeEntry();
    }

    private void backupDirectory(String string, boolean bl, ArrayList<String> arrayList) throws NoRouteToHostException {
        int n;
        String[] stringArray;
        if (!this.fileInterface.fileExists(string)) {
            return;
        }
        if (bl) {
            stringArray = this.fileInterface.getDirectoryList(string);
            for (n = 0; n < stringArray.length; ++n) {
                this.backupDirectory(stringArray[n], bl, arrayList);
            }
        }
        stringArray = this.fileInterface.getFileList(string);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
    }

    public Cipher getCipher(int n) {
        try {
            Cipher cipher = Cipher.getInstance("Blowfish/CFB8/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.key_idx, "Blowfish");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_idx);
            cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

