/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.monitor;

import de.eibport.components.monitor.MonitorFilter;
import de.eibport.components.monitor.MonitorModelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class MonitorModel<T> {
    private ArrayList<T> itemList = new ArrayList();
    private MonitorFilter<T> monitorFilter = null;
    private EventListenerList listener = new EventListenerList();

    public void addMonitorModelListener(MonitorModelListener<T> monitorModelListener) {
        this.listener.add(MonitorModelListener.class, monitorModelListener);
    }

    public void removeMonitorModelListener(MonitorModelListener<T> monitorModelListener) {
        this.listener.remove(MonitorModelListener.class, monitorModelListener);
    }

    protected void fireItemsAdded(T[] TArray) {
        for (MonitorModelListener monitorModelListener : (MonitorModelListener[])this.listener.getListeners(MonitorModelListener.class)) {
            monitorModelListener.itemsAdded(TArray);
        }
    }

    protected void fireItemAdded(T t) {
        for (MonitorModelListener monitorModelListener : (MonitorModelListener[])this.listener.getListeners(MonitorModelListener.class)) {
            monitorModelListener.itemAdded(t);
        }
    }

    protected void fireItemRemoved(T t) {
        for (MonitorModelListener monitorModelListener : (MonitorModelListener[])this.listener.getListeners(MonitorModelListener.class)) {
            monitorModelListener.itemRemoved(t);
        }
    }

    protected void fireModelCleared() {
        for (MonitorModelListener monitorModelListener : (MonitorModelListener[])this.listener.getListeners(MonitorModelListener.class)) {
            monitorModelListener.modelCleared();
        }
    }

    public void setMonitorFilter(MonitorFilter<T> monitorFilter) {
        this.monitorFilter = monitorFilter;
    }

    public void addItems(T[] TArray) {
        for (T t : TArray) {
            this.itemList.add(t);
        }
        this.fireItemsAdded(TArray);
    }

    public void addItem(T t) {
        this.itemList.add(t);
        this.fireItemAdded(t);
    }

    public void removeTelegram(T t) {
        this.itemList.remove(t);
        this.fireItemRemoved(t);
    }

    public void clearItems() {
        this.itemList.clear();
        this.fireModelCleared();
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public T getItem(int n) {
        return this.itemList.get(n);
    }

    public List<T> getItems() {
        if (this.monitorFilter == null) {
            return this.getFilteredItems(this.monitorFilter);
        }
        return this.itemList;
    }

    public List<T> getFilteredItems(MonitorFilter<T> monitorFilter) {
        if (monitorFilter == null) {
            return this.getItems();
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : this.itemList) {
            if (!monitorFilter.accept(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public int size() {
        return this.itemList.size();
    }
}

