/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.login.model;

import de.babtec.globals.HashUtils;
import de.eibport.login.model.EpSystemUser;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EpSystemUserPool {
    private Document doc;
    private ArrayList<EpSystemUser> users = new ArrayList();
    private boolean rescue = false;

    public EpSystemUserPool(Document document, boolean bl) {
        this.doc = document;
        String string = document.getRootElement().getAttributeValue("version");
        boolean bl2 = "0.1".equals(string);
        for (Element element : document.getRootElement().getChildren()) {
            if (bl2) {
                String string2 = element.getAttributeValue("password");
                element.setAttribute("pwsec", HashUtils.doHash(element.getAttributeValue("username"), string2));
                element.removeAttribute("password");
            }
            this.users.add(new EpSystemUser(element));
        }
        this.rescue = bl;
    }

    public EpSystemUserPool(InputStream inputStream) throws JDOMException, IOException {
        this.loadFromFileInterface(inputStream);
    }

    public boolean isEmpty() {
        return this.users.size() == 0;
    }

    public boolean isRescue() {
        return this.rescue;
    }

    private void loadFromFileInterface(InputStream inputStream) throws JDOMException, IOException {
        try {
            this.doc = new SAXBuilder().build(inputStream);
            for (Element element : this.doc.getRootElement().getChildren()) {
                this.users.add(new EpSystemUser(element));
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            // empty catch block
        }
    }

    public EpSystemUser getUser(String string, String string2) {
        for (EpSystemUser epSystemUser : this.users) {
            if (!epSystemUser.matchLogin(string, string2.toCharArray())) continue;
            return epSystemUser;
        }
        return null;
    }

    public EpSystemUser[] getUserArray() {
        EpSystemUser[] epSystemUserArray = new EpSystemUser[this.users.size()];
        return this.users.toArray(epSystemUserArray);
    }

    public boolean save(EpSystemUser epSystemUser) {
        return false;
    }

    public Document getDocument() {
        this.doc.getRootElement().removeContent();
        for (EpSystemUser epSystemUser : this.users) {
            this.doc.getRootElement().addContent(epSystemUser.getElement());
        }
        return this.doc;
    }
}

