/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast;

import de.eibport.net.mcast.DatagramListener;
import de.eibport.net.mcast.packets.v1.Beacon;
import de.eibport.net.mcast.packets.v1.DatagramHeader;
import de.eibport.net.mcast.packets.v2.BodyJSON;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.event.EventListenerList;

public class MulticastThread
extends Thread {
    public static final String DEFAULT_IP = "239.192.168.27";
    public static InetAddress DEFAULT_GROUP_ADDRESS;
    public static final int DEFAULT_PORT = 1735;
    private InetAddress inetAddress;
    private int port;
    private ArrayList<MulticastSocket> sockets = new ArrayList();
    private Thread[] listenerThread;
    private EventListenerList listener = new EventListenerList();
    private short ownerType = 0;
    private boolean sendBeacons = true;
    private Thread beaconThread = null;
    private Runnable beaconSender = new Runnable(){

        @Override
        public void run() {
            while (!MulticastThread.this.isInterrupted()) {
                MulticastThread.this.sendBytes(EpDatagram.getBeaconDatagram(MulticastThread.this.ownerType).getBytes());
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    };
    private LinkedList<Integer> jsonUniquePacketNoHistory = new LinkedList();

    public MulticastThread(InetAddress inetAddress, int n, short s, boolean bl) {
        this.ownerType = s;
        this.inetAddress = inetAddress;
        this.port = n;
        this.sendBeacons = bl;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.supportsMulticast()) continue;
                try {
                    MulticastSocket multicastSocket = new MulticastSocket(n);
                    multicastSocket.setReuseAddress(true);
                    multicastSocket.setNetworkInterface(networkInterface);
                    this.sockets.add(multicastSocket);
                    System.out.println("bound multicast socket to " + networkInterface.getDisplayName());
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendBytes(byte[] byArray) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.inetAddress, this.port);
            for (MulticastSocket multicastSocket : this.sockets) {
                multicastSocket.send(datagramPacket);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendBytes(byte[] byArray, String string, int n) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n);
            for (MulticastSocket multicastSocket : this.sockets) {
                multicastSocket.send(datagramPacket);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.listenerThread = new Thread[this.sockets.size()];
        for (int i = 0; i < this.sockets.size(); ++i) {
            try {
                this.listenerThread[i] = new Thread((Runnable)new MulticastListener(this.sockets.get(i)), "MulticastSocket_" + this.sockets.get(i).getNetworkInterface().getDisplayName());
                this.listenerThread[i].start();
                continue;
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.sendBeacons) {
            this.startBeacons();
        }
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < this.listenerThread.length; ++i) {
            this.listenerThread[i].interrupt();
        }
    }

    public void startBeacons() {
        if (this.beaconThread != null && this.beaconThread.isAlive()) {
            this.stopBeacons();
        }
        this.beaconThread = new Thread(this.beaconSender);
        this.beaconThread.start();
    }

    public void stopBeacons() {
        if (this.beaconThread != null) {
            this.beaconThread.interrupt();
            this.beaconThread = null;
        }
    }

    private void gotDatagramV1(DatagramPacket datagramPacket) {
        DatagramHeader datagramHeader = new DatagramHeader(datagramPacket);
        switch (datagramHeader.getCommand()) {
            case 2: {
                Beacon beacon = new Beacon(datagramHeader, datagramPacket.getData(), 12);
                this.gotBeaconV1(beacon);
                break;
            }
        }
    }

    private void gotBeaconV1(Beacon beacon) {
        for (DatagramListener datagramListener : (DatagramListener[])this.listener.getListeners(DatagramListener.class)) {
            datagramListener.receivedBeacon(beacon);
        }
    }

    private void gotDatagramV2(DatagramPacket datagramPacket) {
        EpDatagram epDatagram;
        byte[] byArray = datagramPacket.getData();
        try {
            epDatagram = new EpDatagram(byArray, 0, datagramPacket.getLength());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        switch (epDatagram.getHeader().getPropertyShort("hCommand")) {
            case 2: {
                switch (epDatagram.getHeader().getPropertyShort("hType")) {
                    case 8192: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 4096: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 2048: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 2: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 4: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 256: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 1024: {
                        this.gotBeaconV2(epDatagram);
                    }
                }
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                for (DatagramListener datagramListener : (DatagramListener[])this.listener.getListeners(DatagramListener.class)) {
                    try {
                        datagramListener.receivedConfig(epDatagram, datagramPacket.getAddress(), datagramPacket.getPort());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case 8: {
                BodyJSON bodyJSON = (BodyJSON)epDatagram.getBody();
                int n = bodyJSON.getUniquePacketNo();
                if (n != -1 && this.jsonUniquePacketNoHistory.contains(n)) break;
                this.jsonUniquePacketNoHistory.add(n);
                while (this.jsonUniquePacketNoHistory.size() > 4) {
                    this.jsonUniquePacketNoHistory.remove(0);
                }
                for (DatagramListener datagramListener : (DatagramListener[])this.listener.getListeners(DatagramListener.class)) {
                    try {
                        datagramListener.receivedJSON(epDatagram, datagramPacket.getAddress(), datagramPacket.getPort());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                new Thread(){

                    @Override
                    public void run() {
                        EpDatagram epDatagram;
                        try {
                            Thread.sleep(new Random().nextInt(3000));
                        }
                        catch (InterruptedException interruptedException) {
                            this.interrupt();
                        }
                        if (!this.isInterrupted() && (epDatagram = EpDatagram.getBeaconDatagram(MulticastThread.this.ownerType)) != null) {
                            MulticastThread.this.sendBytes(epDatagram.getBytes());
                        }
                    }
                }.start();
                break;
            }
            default: {
                short s = epDatagram.getHeader().getPropertyShort("hCommand");
            }
        }
    }

    private void gotBeaconV2(EpDatagram epDatagram) {
        for (DatagramListener datagramListener : (DatagramListener[])this.listener.getListeners(DatagramListener.class)) {
            datagramListener.receivedBeacon(epDatagram);
        }
    }

    public void addListener(DatagramListener datagramListener) {
        this.listener.add(DatagramListener.class, datagramListener);
    }

    public void removeListener(DatagramListener datagramListener) {
        this.listener.remove(DatagramListener.class, datagramListener);
    }

    static {
        try {
            DEFAULT_GROUP_ADDRESS = InetAddress.getByAddress(new byte[]{-17, -64, -88, 27});
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    class MulticastListener
    implements Runnable {
        MulticastSocket socket;

        public MulticastListener(MulticastSocket multicastSocket) {
            this.socket = multicastSocket;
        }

        @Override
        public void run() {
            try {
                this.socket.joinGroup(MulticastThread.this.inetAddress);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            DatagramPacket datagramPacket = new DatagramPacket(new byte[1024], 1024);
            while (!MulticastThread.this.isInterrupted()) {
                try {
                    this.socket.receive(datagramPacket);
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                switch (datagramPacket.getData()[1]) {
                    case 1: {
                        MulticastThread.this.gotDatagramV1(datagramPacket);
                        break;
                    }
                    case 2: {
                        MulticastThread.this.gotDatagramV2(datagramPacket);
                    }
                }
            }
            try {
                MulticastThread.this.stopBeacons();
                this.socket.leaveGroup(MulticastThread.this.inetAddress);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

