/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast.packets.v2;

import de.eibport.net.mcast.packets.v2.BodyBeaconApplication;
import de.eibport.net.mcast.packets.v2.BodyBeaconEP;
import de.eibport.net.mcast.packets.v2.BodyConfig;
import de.eibport.net.mcast.packets.v2.BodyControl;
import de.eibport.net.mcast.packets.v2.BodyDiscover;
import de.eibport.net.mcast.packets.v2.BodyJSON;
import de.eibport.net.mcast.packets.v2.EpDatagramBody;
import de.eibport.net.mcast.packets.v2.Header;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class EpDatagram {
    private int reachable = 2;
    private Header header;
    private EpDatagramBody body;

    public EpDatagram(byte[] byArray, int n, int n2) throws Exception {
        this.header = new Header(byArray, n);
        switch (this.header.getPropertyShort("hCommand")) {
            case 2: {
                this.body = new BodyBeaconEP(byArray, n + 22);
                break;
            }
            case 5: {
                this.body = new BodyControl(byArray, n + 22);
                break;
            }
            case 4: {
                this.body = new BodyConfig(byArray, n + 22, n2);
                break;
            }
            case 8: {
                this.body = new BodyJSON(byArray, n + 22, n2);
                break;
            }
        }
    }

    public EpDatagram(Header header, EpDatagramBody epDatagramBody) {
        this.header = header;
        this.body = epDatagramBody;
    }

    public Header getHeader() {
        return this.header;
    }

    public EpDatagramBody getBody() {
        return this.body;
    }

    public String toString() {
        return this.body.getDescription();
    }

    public static EpDatagram getDiscoverDatagram(short s) {
        return new EpDatagram(Header.getInstance((short)1, s), BodyDiscover.getInstance());
    }

    public static EpDatagram getBeaconDatagram(short s) {
        switch (s) {
            case 64: {
                return new EpDatagram(Header.getInstance((short)2, s), BodyBeaconApplication.getInstance());
            }
            case 512: {
                return new EpDatagram(Header.getInstance((short)2, s), BodyBeaconApplication.getInstance());
            }
        }
        return null;
    }

    public static EpDatagram getConfigDatagram(short s, byte by, String string) {
        return new EpDatagram(Header.getInstance((short)4, s), BodyConfig.getInstance(string, by));
    }

    public static EpDatagram getDatagram(short s, short s2, EpDatagramBody epDatagramBody) {
        return new EpDatagram(Header.getInstance(s, s2), epDatagramBody);
    }

    public static EpDatagram getControlDatagram(short s, byte by, short s2) {
        return new EpDatagram(Header.getInstance((short)5, s), BodyControl.getInstance(by, s2));
    }

    public void testReachable(final ActionListener actionListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    if (EpDatagram.this.header.getInetAddress("hIP").isReachable(5000)) {
                        EpDatagram.this.reachable = 1;
                    } else {
                        EpDatagram.this.reachable = 0;
                    }
                    actionListener.actionPerformed(new ActionEvent(EpDatagram.this, 0, "reachable"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }.start();
    }

    public int isReachable() {
        return this.reachable;
    }

    public boolean isInRescueMode() {
        return (this.body.getPropertyShort("bFlags") & 0x100) > 0;
    }

    public byte[] getBytes() {
        byte[] byArray = this.header.getBytes();
        byte[] byArray2 = this.body.getBytes();
        byte[] byArray3 = new byte[this.body.getLength() == 0 ? byArray.length + byArray2.length : this.body.getLength()];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

