/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;

public class PackedZipLoader {
    public static final int NO_ERROR = 0;
    public static final int ERROR_WHILE_READING = 1;
    public static final int ERROR_EMPTY_ZIP = 2;
    public static final int ERROR_CORRUPTED_XML = 3;
    public static int LAST_ERROR_CODE = 0;

    public static Document getZippedDocument(InputStream inputStream, String string) throws Exception {
        Document document = null;
        try {
            document = PackedZipLoader.readZippedDocument(inputStream);
        }
        catch (IOException iOException) {
            LAST_ERROR_CODE = 1;
            throw new Exception("Error while reading zipped data. (" + string + ")");
        }
        catch (JDOMException jDOMException) {
            LAST_ERROR_CODE = 3;
            throw new Exception("Zip file contains corrupted XML data. (" + string + ")");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (document == null) {
            LAST_ERROR_CODE = 2;
            throw new Exception("Zip file is empty. (" + string + ")");
        }
        return document;
    }

    private static Document readZippedDocument(InputStream inputStream) throws IOException, JDOMException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while (-1 != (n = ((InputStream)zipInputStream).read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ((InputStream)zipInputStream).close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Document document = null;
        try {
            document = new SAXBuilder().build(new ByteArrayInputStream(byArray2));
        }
        catch (CharConversionException charConversionException) {
            System.out.println("Possibly found ISO encoded document... trying to convert to UTF-8.");
            document = PackedZipLoader.readIsoDocument(new ByteArrayInputStream(byArray2));
        }
        catch (JDOMParseException jDOMParseException) {
            System.out.println("Possibly found ISO encoded document... trying to convert to UTF-8.");
            document = PackedZipLoader.readIsoDocument(new ByteArrayInputStream(byArray2));
        }
        return document;
    }

    private static Document readIsoDocument(InputStream inputStream) throws IOException, JDOMException {
        Document document = null;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
        document = new SAXBuilder().build(inputStreamReader);
        return document;
    }
}

