/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.jdesktop.animation.timing.TimingEventListener;
import org.jdesktop.animation.timing.TimingSource;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.LinearInterpolator;

public final class Animator {
    private TimingSource timer;
    private TimingSource swingTimer;
    private TimingSourceTarget timingSourceTarget;
    private ArrayList<TimingTarget> targets = new ArrayList();
    private long startTime;
    private long currentStartTime;
    private int currentCycle = 0;
    private boolean intRepeatCount = true;
    private boolean timeToStop = false;
    private boolean hasBegun = false;
    private long pauseBeginTime = 0L;
    private boolean running = false;
    private double repeatCount = 1.0;
    private int startDelay;
    private RepeatBehavior repeatBehavior = RepeatBehavior.REVERSE;
    private EndBehavior endBehavior = EndBehavior.HOLD;
    private int duration;
    private int resolution = 20;
    private float acceleration = 0.0f;
    private float deceleration = 0.0f;
    private float startFraction = 0.0f;
    private Direction direction = Direction.FORWARD;
    private Interpolator interpolator = LinearInterpolator.getInstance();
    public static final int INFINITE = -1;

    private void validateRepeatCount(double d) {
        if (d < 1.0 && d != -1.0) {
            throw new IllegalArgumentException("repeatCount (" + d + ") cannot be <= 0");
        }
    }

    public Animator(int n) {
        this(n, null);
    }

    public Animator(int n, TimingTarget timingTarget) {
        this.duration = n;
        this.addTarget(timingTarget);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.timer = this.swingTimer = new SwingTimingSource();
    }

    public Animator(int n, double d, RepeatBehavior repeatBehavior, TimingTarget timingTarget) {
        this(n, timingTarget);
        this.validateRepeatCount(d);
        this.repeatCount = d;
        this.repeatBehavior = repeatBehavior != null ? repeatBehavior : RepeatBehavior.REVERSE;
        this.intRepeatCount = Math.rint(d) == d;
    }

    public Direction getStartDirection() {
        return this.direction;
    }

    public void setStartDirection(Direction direction) {
        this.throwExceptionIfRunning();
        this.direction = direction;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.throwExceptionIfRunning();
        this.interpolator = interpolator;
    }

    public void setAcceleration(float f) {
        this.throwExceptionIfRunning();
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Acceleration value cannot lie outside [0,1] range");
        }
        if (f > 1.0f - this.deceleration) {
            throw new IllegalArgumentException("Acceleration value cannot be greater than (1 - deceleration)");
        }
        this.acceleration = f;
    }

    public void setDeceleration(float f) {
        this.throwExceptionIfRunning();
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Deceleration value cannot lie outside [0,1] range");
        }
        if (f > 1.0f - this.acceleration) {
            throw new IllegalArgumentException("Deceleration value cannot be greater than (1 - acceleration)");
        }
        this.deceleration = f;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getDeceleration() {
        return this.deceleration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(TimingTarget timingTarget) {
        if (timingTarget != null) {
            ArrayList<TimingTarget> arrayList = this.targets;
            synchronized (arrayList) {
                if (!this.targets.contains(timingTarget)) {
                    this.targets.add(timingTarget);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(TimingTarget timingTarget) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.remove(timingTarget);
        }
    }

    private void throwExceptionIfRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while Animator is running");
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("resolution must be >= 0");
        }
        this.throwExceptionIfRunning();
        this.resolution = n;
        this.timer.setResolution(n);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        this.throwExceptionIfRunning();
        this.duration = n;
    }

    public double getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(double d) {
        this.validateRepeatCount(d);
        this.throwExceptionIfRunning();
        this.repeatCount = d;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("startDelay (" + n + ") cannot be < 0");
        }
        this.throwExceptionIfRunning();
        this.startDelay = n;
        this.timer.setStartDelay(n);
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public void setRepeatBehavior(RepeatBehavior repeatBehavior) {
        this.throwExceptionIfRunning();
        this.repeatBehavior = repeatBehavior != null ? repeatBehavior : RepeatBehavior.REVERSE;
    }

    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }

    public void setEndBehavior(EndBehavior endBehavior) {
        this.throwExceptionIfRunning();
        this.endBehavior = endBehavior;
    }

    public float getStartFraction() {
        return this.startFraction;
    }

    public void setStartFraction(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("initialFraction must be between 0 and 1");
        }
        this.throwExceptionIfRunning();
        this.startFraction = f;
    }

    public void start() {
        this.throwExceptionIfRunning();
        this.hasBegun = false;
        this.running = true;
        this.startTime = System.nanoTime() / 1000000L + (long)this.getStartDelay();
        if (this.duration != -1 && (this.direction == Direction.FORWARD && this.startFraction > 0.0f || this.direction == Direction.BACKWARD && this.startFraction < 1.0f)) {
            float f = this.direction == Direction.FORWARD ? this.startFraction : 1.0f - this.startFraction;
            long l = (long)((float)this.duration * f);
            this.startTime -= l;
        }
        this.currentStartTime = this.startTime;
        this.timer.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.timer.stop();
        this.end();
        this.timeToStop = false;
        this.running = false;
        this.pauseBeginTime = 0L;
    }

    public void cancel() {
        this.timer.stop();
        this.timeToStop = false;
        this.running = false;
        this.pauseBeginTime = 0L;
    }

    public void pause() {
        if (this.isRunning()) {
            this.pauseBeginTime = System.nanoTime();
            this.running = false;
            this.timer.stop();
        }
    }

    public void resume() {
        if (this.pauseBeginTime > 0L) {
            long l = (System.nanoTime() - this.pauseBeginTime) / 1000000L;
            this.startTime += l;
            this.currentStartTime += l;
            this.timer.start();
            this.pauseBeginTime = 0L;
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timingEvent(float f) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.timingEvent(f);
            }
        }
        if (this.timeToStop) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.begin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repeat() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.repeat();
            }
        }
    }

    private float timingEventPreprocessor(float f) {
        if (this.acceleration != 0.0f || this.deceleration != 0.0f) {
            float f2 = f;
            float f3 = 1.0f / (1.0f - this.acceleration / 2.0f - this.deceleration / 2.0f);
            if (f < this.acceleration) {
                float f4 = f3 * (f / this.acceleration) / 2.0f;
                f *= f4;
            } else if (f > 1.0f - this.deceleration) {
                float f5 = f - (1.0f - this.deceleration);
                float f6 = f5 / this.deceleration;
                f = f3 * (1.0f - this.acceleration / 2.0f - this.deceleration + f5 * (2.0f - f6) / 2.0f);
            } else {
                f = f3 * (f - this.acceleration / 2.0f);
            }
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 1.0f) {
                f = 1.0f;
            }
        }
        return this.interpolator.interpolate(f);
    }

    public long getTotalElapsedTime(long l) {
        return l - this.startTime;
    }

    public long getTotalElapsedTime() {
        long l = System.nanoTime() / 1000000L;
        return this.getTotalElapsedTime(l);
    }

    public long getCycleElapsedTime(long l) {
        return l - this.currentStartTime;
    }

    public long getCycleElapsedTime() {
        long l = System.nanoTime() / 1000000L;
        return this.getCycleElapsedTime(l);
    }

    public float getTimingFraction() {
        float f;
        long l = System.nanoTime() / 1000000L;
        long l2 = this.getCycleElapsedTime(l);
        long l3 = this.getTotalElapsedTime(l);
        double d = (double)l3 / (double)this.duration;
        if (!this.hasBegun) {
            this.begin();
            this.hasBegun = true;
        }
        if (this.duration != -1 && this.repeatCount != -1.0 && d >= this.repeatCount) {
            switch (this.endBehavior) {
                case HOLD: {
                    if (this.intRepeatCount) {
                        if (this.direction == Direction.BACKWARD) {
                            f = 0.0f;
                            break;
                        }
                        f = 1.0f;
                        break;
                    }
                    f = Math.min(1.0f, (float)l2 / (float)this.duration);
                    break;
                }
                case RESET: {
                    f = 0.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            this.timeToStop = true;
        } else if (this.duration != -1 && l2 > (long)this.duration) {
            long l4 = l2 % (long)this.duration;
            f = (float)l4 / (float)this.duration;
            this.currentStartTime = l - l4;
            if (this.repeatBehavior == RepeatBehavior.REVERSE) {
                boolean bl;
                boolean bl2 = bl = (int)(l2 / (long)this.duration) % 2 > 0;
                if (bl) {
                    Direction direction = this.direction = this.direction == Direction.FORWARD ? Direction.BACKWARD : Direction.FORWARD;
                }
                if (this.direction == Direction.BACKWARD) {
                    f = 1.0f - f;
                }
            }
            this.repeat();
        } else {
            f = 0.0f;
            if (this.duration != -1) {
                f = (float)l2 / (float)this.duration;
                if (this.direction == Direction.BACKWARD) {
                    f = 1.0f - f;
                }
                f = Math.min(f, 1.0f);
                f = Math.max(f, 0.0f);
            }
        }
        return this.timingEventPreprocessor(f);
    }

    public synchronized void setTimer(TimingSource timingSource) {
        this.throwExceptionIfRunning();
        if (this.timer != this.swingTimer) {
            this.timer.removeEventListener(this.timingSourceTarget);
        }
        if (timingSource == null) {
            this.timer = this.swingTimer;
        } else {
            this.timer = timingSource;
            if (this.timingSourceTarget == null) {
                this.timingSourceTarget = new TimingSourceTarget();
            }
            timingSource.addEventListener(this.timingSourceTarget);
        }
        this.timer.setResolution(this.resolution);
        this.timer.setStartDelay(this.startDelay);
    }

    private class TimerTarget
    implements ActionListener {
        private TimerTarget() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Animator.this.timingEvent(Animator.this.getTimingFraction());
        }
    }

    private class SwingTimingSource
    extends TimingSource {
        Timer timer;

        public SwingTimingSource() {
            this.timer = new Timer(Animator.this.resolution, new TimerTarget());
            this.timer.setInitialDelay(0);
        }

        @Override
        public void start() {
            this.timer.start();
        }

        @Override
        public void stop() {
            this.timer.stop();
        }

        @Override
        public void setResolution(int n) {
            this.timer.setDelay(n);
        }

        @Override
        public void setStartDelay(int n) {
            this.timer.setInitialDelay(n);
        }
    }

    class TimingSourceTarget
    implements TimingEventListener {
        TimingSourceTarget() {
        }

        @Override
        public void timingSourceEvent(TimingSource timingSource) {
            if (Animator.this.timer == timingSource && Animator.this.running) {
                Animator.this.timingEvent(Animator.this.getTimingFraction());
            }
        }
    }

    public static enum RepeatBehavior {
        LOOP,
        REVERSE;

    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    public static enum EndBehavior {
        HOLD,
        RESET;

    }
}

