/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public abstract class XPath
implements Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: XPath.java,v $ $Revision: 1.17 $ $Date: 2007/11/10 05:29:02 $ $Name: jdom_1_1 $";
    private static final String XPATH_CLASS_PROPERTY = "org.jdom.xpath.class";
    private static final String DEFAULT_XPATH_CLASS = "org.jdom.xpath.JaxenXPath";
    public static final String JDOM_OBJECT_MODEL_URI = "http://jdom.org/jaxp/xpath/jdom";
    private static Constructor constructor = null;

    public static XPath newInstance(String string) throws JDOMException {
        try {
            if (constructor == null) {
                String string2;
                try {
                    string2 = System.getProperty(XPATH_CLASS_PROPERTY, DEFAULT_XPATH_CLASS);
                }
                catch (SecurityException securityException) {
                    string2 = DEFAULT_XPATH_CLASS;
                }
                XPath.setXPathClass(Class.forName(string2));
            }
            return (XPath)constructor.newInstance(string);
        }
        catch (JDOMException jDOMException) {
            throw jDOMException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw throwable instanceof JDOMException ? (JDOMException)throwable : new JDOMException(throwable.toString(), throwable);
        }
        catch (Exception exception) {
            throw new JDOMException(exception.toString(), exception);
        }
    }

    public static void setXPathClass(Class clazz) throws JDOMException {
        if (clazz == null) {
            throw new IllegalArgumentException("aClass");
        }
        try {
            if (!XPath.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) {
                throw new JDOMException(clazz.getName() + " is not a concrete JDOM XPath implementation");
            }
            constructor = clazz.getConstructor(String.class);
        }
        catch (JDOMException jDOMException) {
            throw jDOMException;
        }
        catch (Exception exception) {
            throw new JDOMException(exception.toString(), exception);
        }
    }

    public abstract List selectNodes(Object var1) throws JDOMException;

    public abstract Object selectSingleNode(Object var1) throws JDOMException;

    public abstract String valueOf(Object var1) throws JDOMException;

    public abstract Number numberValueOf(Object var1) throws JDOMException;

    public abstract void setVariable(String var1, Object var2);

    public abstract void addNamespace(Namespace var1);

    public void addNamespace(String string, String string2) {
        this.addNamespace(Namespace.getNamespace(string, string2));
    }

    public abstract String getXPath();

    public static List selectNodes(Object object, String string) throws JDOMException {
        return XPath.newInstance(string).selectNodes(object);
    }

    public static Object selectSingleNode(Object object, String string) throws JDOMException {
        return XPath.newInstance(string).selectSingleNode(object);
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return new XPathString(this.getXPath());
    }

    private static final class XPathString
    implements Serializable {
        private String xPath = null;

        public XPathString(String string) {
            this.xPath = string;
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return XPath.newInstance(this.xPath);
            }
            catch (JDOMException jDOMException) {
                throw new InvalidObjectException("Can't create XPath object for expression \"" + this.xPath + "\": " + jDOMException.toString());
            }
        }
    }
}

