/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.AbstractUnitConverter;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class DefaultUnitConverter
extends AbstractUnitConverter {
    private static DefaultUnitConverter instance;
    private String averageCharWidthTestString = "X";
    private Font defaultDialogFont;
    private PropertyChangeSupport changeSupport;
    private DialogBaseUnits cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
    private Map cachedDialogBaseUnits = new HashMap();

    private DefaultUnitConverter() {
        UIManager.addPropertyChangeListener(new LAFChangeHandler());
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public static DefaultUnitConverter getInstance() {
        if (instance == null) {
            instance = new DefaultUnitConverter();
        }
        return instance;
    }

    public String getAverageCharacterWidthTestString() {
        return this.averageCharWidthTestString;
    }

    public void setAverageCharacterWidthTestString(String string) {
        if (string == null) {
            throw new NullPointerException("The test string must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The test string must not be empty.");
        }
        String string2 = this.averageCharWidthTestString;
        this.averageCharWidthTestString = string;
        this.changeSupport.firePropertyChange("averageCharacterWidthTestString", string2, string);
    }

    public Font getDefaultDialogFont() {
        if (this.defaultDialogFont == null) {
            this.defaultDialogFont = this.lookupDefaultDialogFont();
        }
        return this.defaultDialogFont;
    }

    public void setDefaultDialogFont(Font font) {
        Font font2 = this.defaultDialogFont;
        this.defaultDialogFont = font;
        this.changeSupport.firePropertyChange("defaultDialogFont", font2, font);
    }

    @Override
    protected double getDialogBaseUnitsX(Component component) {
        return this.getDialogBaseUnits((Component)component).x;
    }

    @Override
    protected double getDialogBaseUnitsY(Component component) {
        return this.getDialogBaseUnits((Component)component).y;
    }

    private DialogBaseUnits getGlobalDialogBaseUnits() {
        if (this.cachedGlobalDialogBaseUnits == null) {
            this.cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
        }
        return this.cachedGlobalDialogBaseUnits;
    }

    private DialogBaseUnits getDialogBaseUnits(Component component) {
        if (component == null) {
            this.logInfo("Missing font metrics: " + component);
            return this.getGlobalDialogBaseUnits();
        }
        FontMetrics fontMetrics = component.getFontMetrics(this.getDefaultDialogFont());
        DialogBaseUnits dialogBaseUnits = (DialogBaseUnits)this.cachedDialogBaseUnits.get(fontMetrics);
        if (dialogBaseUnits == null) {
            dialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
            this.cachedDialogBaseUnits.put(fontMetrics, dialogBaseUnits);
        }
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeDialogBaseUnits(FontMetrics fontMetrics) {
        double d = this.computeAverageCharWidth(fontMetrics, this.averageCharWidthTestString);
        int n = fontMetrics.getAscent();
        double d2 = n > 14 ? (double)n : (double)(n + (15 - n) / 3);
        DialogBaseUnits dialogBaseUnits = new DialogBaseUnits(d, d2);
        this.logInfo("Computed dialog base units " + dialogBaseUnits + " for: " + fontMetrics.getFont());
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeGlobalDialogBaseUnits() {
        this.logInfo("Computing global dialog base units...");
        Font font = this.getDefaultDialogFont();
        FontMetrics fontMetrics = this.createDefaultGlobalComponent().getFontMetrics(font);
        DialogBaseUnits dialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
        return dialogBaseUnits;
    }

    private Font lookupDefaultDialogFont() {
        Font font = UIManager.getFont("Button.font");
        return font != null ? font : new JButton().getFont();
    }

    private Component createDefaultGlobalComponent() {
        return new JPanel();
    }

    private void invalidateCaches() {
        this.cachedGlobalDialogBaseUnits = null;
        this.cachedDialogBaseUnits.clear();
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private void logInfo(String string) {
    }

    private class LAFChangeHandler
    implements PropertyChangeListener {
        private LAFChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DefaultUnitConverter.this.invalidateCaches();
        }
    }

    private static class DialogBaseUnits {
        final double x;
        final double y;

        DialogBaseUnits(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return "DBU(x=" + this.x + "; y=" + this.y + ")";
        }
    }
}

