/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals;

public class Version
implements Comparable<Version> {
    private int[] vs = new int[4];

    public Version(String string) {
        if (!string.matches("\\d+\\.\\d+\\.\\d+(?:-pre\\d+)?")) {
            throw new IllegalArgumentException("Inavid version number. Does not match pattern X.Y.Z-preA");
        }
        string = string.replace("-pre", ".");
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            this.vs[i] = Integer.parseInt(stringArray[i]);
        }
    }

    public int getMajor() {
        return this.vs[0];
    }

    public int getMinor() {
        return this.vs[1];
    }

    public int getRevision() {
        return this.vs[2];
    }

    public int getPre() {
        return this.vs[3];
    }

    @Override
    public int compareTo(Version version) {
        for (int i = 0; i < 3; ++i) {
            if (this.vs[i] > version.vs[i]) {
                return 1;
            }
            if (this.vs[i] >= version.vs[i]) continue;
            return -1;
        }
        if (this.vs[3] == version.vs[3]) {
            return 0;
        }
        if (this.vs[3] == 0) {
            return 1;
        }
        if (version.vs[3] == 0) {
            return -1;
        }
        if (this.vs[3] > version.vs[3]) {
            return 1;
        }
        if (this.vs[3] < version.vs[3]) {
            return -1;
        }
        return 0;
    }

    public boolean isNewerThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isNewerOrEqual(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isEqualTo(Version version) {
        return this.compareTo(version) == 0;
    }

    public boolean isOlderThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isOlderOrEqual(Version version) {
        return this.compareTo(version) <= 0;
    }

    public static int compare(String string, String string2) {
        return new Version(string).compareTo(new Version(string2));
    }

    public static boolean isNewerThan(String string, String string2) {
        return new Version(string).isNewerThan(new Version(string2));
    }

    public static boolean isNewerOrEqual(String string, String string2) {
        return new Version(string).isNewerOrEqual(new Version(string2));
    }

    public static boolean isEqualTo(String string, String string2) {
        return new Version(string).isEqualTo(new Version(string2));
    }

    public static boolean isOlderThan(String string, String string2) {
        return new Version(string).isOlderThan(new Version(string2));
    }

    public static boolean isOlderOrEqual(String string, String string2) {
        return new Version(string).isOlderOrEqual(new Version(string2));
    }
}

