/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata;

import de.babtec.globals.deprecated.eibaddress.AddressObject;
import de.babtec.globals.deprecated.eibaddress.IllegalAddressException;
import de.babtec.globals.jobdata.BMXBasicJobData;
import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.knx.address.EIBAddressObject2;
import java.util.ArrayList;

public class BMXJobData
extends BMXBasicJobData {
    private byte[] param;
    private ArrayList<EIBAddressObject2> addressObjects = new ArrayList();

    public BMXJobData(LibID libID, String string, boolean bl, byte[] byArray) {
        super(libID, string.trim(), bl);
        this.param = byArray;
    }

    public BMXJobData(byte[] byArray) {
        super(byArray);
        if (this.libID == null) {
            return;
        }
        int n = (byArray[23] & 0xFF) << 8 | byArray[22] & 0xFF;
        this.param = new byte[n];
        System.arraycopy(byArray, 24, this.param, 0, n);
        int n2 = (byArray[25 + n] & 0xFF) << 8 | byArray[24 + n] & 0xFF;
        int n3 = n2 / 28;
        for (int i = 0; i < n3; ++i) {
            int n4 = 26 + n + i * 28;
            int[] nArray = new int[5];
            for (int j = 0; j < 5; ++j) {
                nArray[j] = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8;
            }
            this.addressObjects.add(new EIBAddressObject2(nArray));
        }
    }

    public byte[] getDataPackage() {
        int n = this.param.length;
        int n2 = this.addressObjects.size() * 28;
        byte[] byArray = new byte[26 + n + n2];
        byArray[0] = (byte)(byArray.length & 0xFF);
        byArray[1] = (byte)(byArray.length >> 8 & 0xFF);
        System.arraycopy(this.libID.getLibID(), 0, byArray, 2, 4);
        System.arraycopy(this.getNameBytes(), 0, byArray, 6, this.getNameBytes().length);
        byArray[22] = (byte)(n & 0xFF);
        byArray[23] = (byte)(n >> 8 & 0xFF);
        System.arraycopy(this.param, 0, byArray, 24, n);
        byArray[24 + n] = (byte)(n2 & 0xFF);
        byArray[25 + n] = (byte)(n2 >> 8 & 0xFF);
        for (int i = 0; i < this.addressObjects.size(); ++i) {
            int[] nArray;
            int n3 = 26 + n + i * 28;
            EIBAddressObject2 eIBAddressObject2 = this.addressObjects.get(i);
            for (int n4 : nArray = eIBAddressObject2 != null ? eIBAddressObject2.getAddressObjectAsInteger() : new int[]{}) {
                byArray[n3++] = (byte)(n4 & 0xFF);
                byArray[n3++] = (byte)((n4 & 0xFF00) >> 8);
            }
        }
        return byArray;
    }

    public int getAddressObjectCount() {
        return this.addressObjects.size();
    }

    public EIBAddressObject2 getEIBAddressObject2(int n) {
        return this.addressObjects.get(n);
    }

    public void addEIBAddressObject2(EIBAddressObject2 eIBAddressObject2) {
        this.addressObjects.add(eIBAddressObject2);
    }

    @Deprecated
    public AddressObject getAddressObject(int n) {
        if (n >= this.addressObjects.size()) {
            return null;
        }
        try {
            return new AddressObject(this.addressObjects.get(n).getAddressObjectAsString());
        }
        catch (IllegalAddressException illegalAddressException) {
            return null;
        }
    }

    @Deprecated
    public void addAddressObject(AddressObject addressObject) {
        this.addressObjects.add(new EIBAddressObject2(addressObject.getAddressString()));
    }

    public void addAddressObjectDummy() {
        this.addressObjects.add(new EIBAddressObject2(new int[0]));
    }

    public byte[] getParam() {
        return this.param;
    }
}

