/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.ekey;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXEkey
extends BMXJobModel {
    public static final int JOBS_EKEY_MAX_ENTRIES = 8;
    public static final int JOBS_EKEY_MAX_COMBINATIONS = 4;
    public static final int JOBS_EKEY_VERSION1_COMBI_RESERVED = 8;
    public static final int JOBS_EKEY_VERSION1_ENTRY_RESERVED = 8;
    public static final int JOBS_EKEY_VERSION1_JOB_RESERVED = 127;
    public static final int JOBS_EKEY_VERSION1_EOS_RESERVED = 12;
    public static final int JOBS_EKEY_OBMAX = 30;
    public static final int JOBS_EKEY_FLAGS_READER_WILDCARD = 1;
    public static final int JOBS_EKEY_FLAGS_ALL = 1;
    public static final int JOBS_EKEY_ACTUAL_VERSION = 1;
    public static final int JOBS_EKEY_ENTRY_FLAG_SEND_MATCHING_COMBINATION = 1;
    public static final int JOBS_EKEY_COMBINATION_FLAG_ACTIVE = 1;
    private int flags;
    private int version = 1;
    private int port;
    private int readerId;
    private EIBAddressObject2 objNoMatchOutput;
    private int noMatchEis;
    private int noMatchValue;
    private int protocolType;
    private BMXEkeyEntry[] entries = new BMXEkeyEntry[8];
    private EIBAddressObject2 objEnable;

    public BMXEkey(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXEkey() {
        for (int i = 0; i < 8; ++i) {
            this.entries[i] = new BMXEkeyEntry();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getReaderId() {
        return this.readerId;
    }

    public void setReaderId(int n) {
        this.readerId = n;
    }

    public EIBAddressObject2 getObjNoMatchOutput() {
        return this.objNoMatchOutput;
    }

    public void setObjNoMatchOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objNoMatchOutput = eIBAddressObject2;
    }

    public int getNoMatchEis() {
        return this.noMatchEis;
    }

    public void setNoMatchEis(int n) {
        this.noMatchEis = n;
    }

    public int getNoMatchValue() {
        return this.noMatchValue;
    }

    public void setNoMatchValue(int n) {
        this.noMatchValue = n;
    }

    public int getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(int n) {
        this.protocolType = n;
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++] & 0xFF;
        this.version = byArray[n2++] & 0xFF;
        this.port = ByteConv.byte2short(byArray, n2);
        this.readerId = ByteConv.byte2long(byArray, n2 += 2);
        n2 += 4;
        for (n = 0; n < 8; ++n) {
            if (bMXJobData.getEIBAddressObject2(1 + n).getAddressCount() == 0) {
                n2 += 84;
                continue;
            }
            BMXEkeyEntry bMXEkeyEntry = this.getEntry(n);
            bMXEkeyEntry.flags = byArray[n2++] & 0xFF;
            bMXEkeyEntry.combinationCount = byArray[n2++] & 0xFF;
            for (int i = 0; i < bMXEkeyEntry.combinations.length; ++i) {
                bMXEkeyEntry.combinations[i].flags = byArray[n2++];
                bMXEkeyEntry.combinations[i].user = ByteConv.byte2short(byArray, ++n2);
                bMXEkeyEntry.combinations[i].finger = ByteConv.byte2short(byArray, n2 += 2);
                n2 += 2;
                n2 += 8;
            }
            bMXEkeyEntry.eis = byArray[n2++] & 0xFF;
            bMXEkeyEntry.value = byArray[n2++] & 0xFF;
            bMXEkeyEntry.description = ByteConv.byte2string(byArray, n2, 16);
            n2 += 16;
            n2 += 8;
            bMXEkeyEntry.objOutput = bMXJobData.getEIBAddressObject2(1 + n);
            bMXEkeyEntry.objActive = bMXJobData.getEIBAddressObject2(9 + n);
        }
        this.noMatchEis = byArray[n2++] & 0xFF;
        this.noMatchValue = byArray[n2++] & 0xFF;
        this.protocolType = byArray[n2++] & 0xFF;
        n2 += 127;
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        this.objNoMatchOutput = bMXJobData.getEIBAddressObject2(17);
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.flags);
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(ByteConv.short2byte(this.port));
            byteArrayOutputStream.write(ByteConv.long2byte(this.readerId));
            for (int i = 0; i < 8; ++i) {
                BMXEkeyEntry bMXEkeyEntry = this.getEntry(i);
                byteArrayOutputStream.write(bMXEkeyEntry.flags);
                byteArrayOutputStream.write(bMXEkeyEntry.combinationCount);
                for (int j = 0; j < bMXEkeyEntry.combinations.length; ++j) {
                    byteArrayOutputStream.write(bMXEkeyEntry.combinations[j].flags);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(ByteConv.short2byte(bMXEkeyEntry.combinations[j].user));
                    byteArrayOutputStream.write(ByteConv.short2byte(bMXEkeyEntry.combinations[j].finger));
                    byteArrayOutputStream.write(new byte[8]);
                }
                byteArrayOutputStream.write(bMXEkeyEntry.eis);
                byteArrayOutputStream.write(bMXEkeyEntry.value);
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(bMXEkeyEntry.description, 16));
                byteArrayOutputStream.write(new byte[8]);
            }
            byteArrayOutputStream.write(this.noMatchEis);
            byteArrayOutputStream.write(this.noMatchValue);
            byteArrayOutputStream.write(this.protocolType);
            byteArrayOutputStream.write(new byte[127]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_EKEY, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        for (n = 0; n < 8; ++n) {
            bMXJobData.addEIBAddressObject2(this.getEntry(n).objOutput);
        }
        for (n = 0; n < 8; ++n) {
            bMXJobData.addEIBAddressObject2(this.getEntry(n).objActive);
        }
        bMXJobData.addEIBAddressObject2(this.objNoMatchOutput);
        for (n = 0; n < 12; ++n) {
            bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? this.flags | n : this.flags & ~n;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) > 0;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public BMXEkeyEntry getEntry(int n) {
        return this.entries[n];
    }

    public void setEntry(int n, BMXEkeyEntry bMXEkeyEntry) {
        if (n >= 8) {
            throw new RuntimeException("Need 4 entries!");
        }
        this.entries[n] = bMXEkeyEntry;
    }

    public class BMXEkeyEntry {
        private int flags = 0;
        private int combinationCount = 0;
        private int eis = 10000010;
        private int value = 1;
        private BMXEkeyCombination[] combinations = new BMXEkeyCombination[4];
        private String description = "";
        private EIBAddressObject2 objActive = new EIBAddressObject2("");
        private EIBAddressObject2 objOutput = new EIBAddressObject2("");

        public BMXEkeyEntry() {
            for (int i = 0; i < this.combinations.length; ++i) {
                this.combinations[i] = new BMXEkeyCombination();
            }
        }

        public void setFlag(int n, boolean bl) {
            this.flags = bl ? this.flags | n : this.flags & ~n;
        }

        public boolean getFlag(int n) {
            return (this.flags & n) > 0;
        }

        public int getCombinationCount() {
            return this.combinationCount;
        }

        public void setCombinationCount(int n) {
            this.combinationCount = n;
        }

        public BMXEkeyCombination getCombination(int n) {
            return this.combinations[n];
        }

        public void setCombination(BMXEkeyCombination bMXEkeyCombination, int n) {
            if (n >= 4) {
                throw new RuntimeException("Need 4 combinations!");
            }
            this.combinations[n] = bMXEkeyCombination;
        }

        public int getEis() {
            return this.eis;
        }

        public void setEis(int n) {
            this.eis = n;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string.substring(0, Math.min(16, string.length()));
        }

        public EIBAddressObject2 getObjActive() {
            return this.objActive;
        }

        public void setObjActive(EIBAddressObject2 eIBAddressObject2) {
            this.objActive = eIBAddressObject2;
        }

        public EIBAddressObject2 getObjOutput() {
            return this.objOutput;
        }

        public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
            this.objOutput = eIBAddressObject2;
        }
    }

    public class BMXEkeyCombination {
        private int flags;
        private int user = 65535;
        private int finger = 65535;

        public void setFlag(int n, boolean bl) {
            this.flags = bl ? this.flags | n : this.flags & ~n;
        }

        public boolean getFlag(int n) {
            return (this.flags & n) > 0;
        }

        public void setUser(int n) {
            this.user = n;
        }

        public int getUser() {
            return this.user;
        }

        public void setFinger(int n) {
            this.finger = n;
        }

        public int getFinger() {
            return this.finger;
        }
    }
}

