/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.httpreq;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.BMXValueModel;
import de.babtec.globals.jobdata.jobs.httpreq.HttpReqOutputModel;
import de.babtec.globals.jobdata.jobs.httpreq.HttpReqTargetModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.knx.datatype.DataType;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXHttpReqModel
extends BMXJobModel {
    public static final int JOBS_HTTPRQ_MAX_SIZE_K = 100;
    public static final int JOBS_HTTPRQ_MAX_TARGETS = 8;
    public static final int JOBS_HTTPRQ_MAX_VALUES = 10;
    public static final int JOBS_HTTPRQ_MAX_REPLACEMENTS = 12;
    public static final int JOBS_HTTPRQ_MAX_OUTPUTS = 4;
    public static final int JOBS_HTTPRQ_MAX_PROTOCOL_LEN = 16;
    public static final int JOBS_HTTPRQ_MAX_BASEURL_LEN = 2048;
    public static final int JOBS_HTTPRQ_MAX_AUTH_NAME_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_AUTH_PASSWD_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_PROXY_URL_LEN = 1024;
    public static final int JOBS_HTTPRQ_MAX_PROXY_NAME_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_PROXY_PASSWD_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_USERAGENT_LEN = 128;
    public static final int JOBS_HTTPRQ_MAX_TARGETURL_LEN = 256;
    public static final int JOBS_HTTPRQ_CA_FILENAME_LEN = 32;
    public static final int JOBS_HTTPRQ_CERT_FILENAME_LEN = 32;
    public static final int JOBS_HTTPRQ_ADD_HEADERS_LEN = 256;
    public static final int REQUEST_TYPE_GET = 0;
    public static final int REQUEST_TYPE_POST = 1;
    public static final int REQUEST_TYPE_PUT = 2;
    public static final int REQUEST_TYPE_DELETE = 3;
    public static final int REQUEST_TYPE_POST_FILE = 4;
    public static final int REQUEST_TYPE_PUT_FILE = 5;
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String CONTENT_TYPE_URLENC = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_APP_JSON = "application/json";
    public static final String[] CONTENT_TYPE_ALL = new String[]{"text/plain", "text/xml", "text/html", "application/x-www-form-urlencoded", "application/json"};
    public static final int JOBS_HTTPRQ_FLAGS_FOLLOW_LOCATION = 1;
    public static final int JOBS_HTTPRQ_FLAGS_VERBOSE = 2;
    public static final int JOBS_HTTPRQ_FLAGS_FAILONERROR = 4;
    public static final int JOBS_HTTPRQ_FLAGS_SSL_VERIFYPEER = 8;
    public static final int JOBS_HTTPRQ_FLAGS_IGNORE_CONTENT_LENGTH = 16;
    public static final int JOBS_HTTPRQ_FLAGS_ALL = 31;
    public static final int JOBS_HTTPRQ_TARGET_FLAG_WILDCARD = 128;
    public static final int JOBS_HTTPRQ_RESULT_PATTERN_LEN = 512;
    public static final int JOBS_HTTPRQ_OBMAX = 18;
    public static final int PCRE_CASELESS = 1;
    public static final int PCRE_MULTILINE = 2;
    public static final int PCRE_DOTALL = 4;
    public static final int PCRE_EXTENDED = 8;
    public static final int PCRE_ANCHORED = 16;
    public static final int PCRE_DOLLAR_ENDONLY = 32;
    public static final int PCRE_EXTRA = 64;
    public static final int PCRE_NOTBOL = 128;
    public static final int PCRE_NOTEOL = 256;
    public static final int PCRE_UNGREEDY = 512;
    public static final int PCRE_NOTEMPTY = 1024;
    public static final int PCRE_UTF8 = 2048;
    public static final int PCRE_NO_AUTO_CAPTURE = 4096;
    public static final int PCRE_NO_UTF8_CHECK = 8192;
    public static final int PCRE_AUTO_CALLOUT = 16384;
    public static final int PCRE_PARTIAL_SOFT = 32768;
    public static final int PCRE_PARTIAL = 32768;
    public static final int PCRE_DFA_SHORTEST = 65536;
    public static final int PCRE_DFA_RESTART = 131072;
    public static final int PCRE_FIRSTLINE = 262144;
    public static final int PCRE_DUPNAMES = 524288;
    public static final int PCRE_NEWLINE_CR = 0x100000;
    public static final int PCRE_NEWLINE_LF = 0x200000;
    public static final int PCRE_NEWLINE_CRLF = 0x300000;
    public static final int PCRE_NEWLINE_ANY = 0x400000;
    public static final int PCRE_NEWLINE_ANYCRLF = 0x500000;
    public static final int PCRE_BSR_ANYCRLF = 0x800000;
    public static final int PCRE_BSR_UNICODE = 0x1000000;
    public static final int PCRE_JAVASCRIPT_COMPAT = 0x2000000;
    public static final int PCRE_NO_START_OPTIMIZE = 0x4000000;
    public static final int PCRE_NO_START_OPTIMISE = 0x4000000;
    public static final int PCRE_PARTIAL_HARD = 0x8000000;
    public static final int PCRE_NOTEMPTY_ATSTART = 0x10000000;
    public static final int PCRE_UCP = 0x20000000;
    private int flags;
    private int total_timeout;
    private int max_size_k;
    private String protocol;
    private String baseURL;
    private String auth_name;
    private String auth_passwd;
    private String proxy_url;
    private String proxy_name;
    private String proxy_passwd;
    private String useragent;
    private byte requestType;
    private String ca_file;
    private String cert_file;
    private String additional_headers;
    private BMXValueModel[] value_format = new BMXValueModel[10];
    private byte result_eis;
    private byte former_output_implementation;
    private int version = 1;
    private String pattern;
    private int compile_flags;
    private int exec_flags;
    private HttpReqOutputModel[] outputs = new HttpReqOutputModel[4];
    private byte target_count;
    private HttpReqTargetModel[] targets = new HttpReqTargetModel[8];
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objInput;
    private EIBAddressObject2[] objValue = new EIBAddressObject2[10];
    private EIBAddressObject2 objErrorTxt;
    private EIBAddressObject2 objResult;
    private EIBAddressObject2[] objOutput = new EIBAddressObject2[4];

    public BMXHttpReqModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXHttpReqModel() {
        int n;
        for (n = 0; n < 10; ++n) {
            this.value_format[n] = new BMXValueModel();
        }
        for (n = 0; n < 8; ++n) {
            this.targets[n] = new HttpReqTargetModel();
        }
        for (n = 0; n < 4; ++n) {
            this.outputs[n] = new HttpReqOutputModel();
        }
    }

    public void setIgnoreContentLength(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean getIgnoreContentLength() {
        return (this.flags & 0x10) > 0;
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        int n2;
        int n3;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n4 = 0;
        this.flags = ByteConv.byte2short(byArray, n4);
        this.total_timeout = ByteConv.byte2short(byArray, n4 += 2);
        this.max_size_k = ByteConv.byte2short(byArray, n4 += 2);
        this.protocol = new String(byArray, n4 += 2, 16).trim();
        this.baseURL = new String(byArray, n4 += 16, 2048).trim();
        this.auth_name = new String(byArray, n4 += 2048, 64).trim();
        this.auth_passwd = new String(byArray, n4 += 64, 64).trim();
        this.proxy_url = new String(byArray, n4 += 64, 1024).trim();
        this.proxy_name = new String(byArray, n4 += 1024, 64).trim();
        this.proxy_passwd = new String(byArray, n4 += 64, 64).trim();
        this.useragent = new String(byArray, n4 += 64, 128).trim();
        n4 += 128;
        this.requestType = byArray[n4++];
        this.ca_file = new String(byArray, n4, 32).trim();
        this.cert_file = new String(byArray, n4 += 32, 32).trim();
        this.additional_headers = new String(byArray, n4 += 32, 256).trim();
        n4 += 256;
        for (n3 = 0; n3 < 10; ++n3) {
            n4 += this.value_format[n3].setBMXJobData(byArray, n4);
        }
        this.result_eis = byArray[n4++];
        this.former_output_implementation = byArray[n4++];
        n3 = n4;
        int n5 = ByteConv.byte2short(byArray, n4);
        n3 += 2;
        if (n5 != 0) {
            this.pattern = ByteConv.byte2string(byArray, n3, 512);
            this.compile_flags = ByteConv.byte2long(byArray, n3 += 512);
            this.exec_flags = ByteConv.byte2long(byArray, n3 += 4);
            n3 += 4;
            for (n2 = 0; n2 < 4; ++n2) {
                this.outputs[n2].setFormat(ByteConv.byte2short(byArray, n3));
                n3 += 2;
                this.outputs[n2].setBinary_lenght((short)(byArray[n3++] & 0xFF));
                this.outputs[n2].setEis((short)(byArray[n3++] & 0xFF));
                this.outputs[n2].setInterpret_format(ByteConv.byte2string(byArray, n3, 8));
                this.outputs[n2].setEis15_format(ByteConv.byte2string(byArray, n3 += 8, 8));
                n3 += 8;
            }
        }
        n4 += 1024;
        this.target_count = byArray[n4++];
        for (n2 = 0; n2 < 8; ++n2) {
            this.targets[n2].setFlags(byArray[n4++]);
            this.targets[n2].setTrigger(byArray[n4++]);
            this.targets[n2].setUrl(new String(byArray, n4, 256).trim());
            n4 += 256;
        }
        n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        this.objInput = bMXJobData.getEIBAddressObject2(n2++);
        for (n = 0; n < 10; ++n) {
            this.objValue[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        this.objErrorTxt = bMXJobData.getEIBAddressObject2(n2++);
        this.objResult = bMXJobData.getEIBAddressObject2(n2++);
        if (n5 == 0) {
            for (n = 0; n < 4; ++n) {
                this.objOutput[n] = new EIBAddressObject2(new int[5]);
            }
        } else {
            for (n = 0; n < 4; ++n) {
                this.objOutput[n] = bMXJobData.getEIBAddressObject2(n2++);
            }
        }
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byteArrayOutputStream.write(ByteConv.short2byte(this.flags));
            byteArrayOutputStream.write(ByteConv.short2byte(this.total_timeout));
            byteArrayOutputStream.write(ByteConv.short2byte(this.max_size_k));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.protocol, 16));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.baseURL, 2048));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.auth_name, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.auth_passwd, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.proxy_url, 1024));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.proxy_name, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.proxy_passwd, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.useragent, 128));
            byteArrayOutputStream.write(this.requestType);
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.ca_file, 32));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.cert_file, 32));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.additional_headers, 256));
            for (n2 = 0; n2 < 10; ++n2) {
                this.value_format[n2].getJobData(byteArrayOutputStream);
            }
            byteArrayOutputStream.write(this.result_eis);
            byteArrayOutputStream.write(this.former_output_implementation);
            n2 = 1024;
            byteArrayOutputStream.write(ByteConv.short2byte(this.version));
            n2 -= 2;
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.pattern, 512));
            n2 -= 512;
            byteArrayOutputStream.write(ByteConv.long2byte(this.compile_flags));
            n2 -= 4;
            byteArrayOutputStream.write(ByteConv.long2byte(this.exec_flags));
            n2 -= 4;
            for (n = 0; n < 4; ++n) {
                if (this.outputs[n].getEis() == DataType.getEis1().getBmxIndex()) {
                    byteArrayOutputStream.write(ByteConv.short2byte(this.outputs[n].getFormat()));
                } else {
                    byteArrayOutputStream.write(ByteConv.short2byte(0));
                }
                n2 -= 2;
                byteArrayOutputStream.write(this.outputs[n].getBinary_lenght());
                --n2;
                byteArrayOutputStream.write(this.outputs[n].getEis());
                --n2;
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.outputs[n].getInterpret_format(), 8));
                n2 -= 8;
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.outputs[n].getEis15_format(), 8));
                n2 -= 8;
            }
            byteArrayOutputStream.write(new byte[n2]);
            byteArrayOutputStream.write(this.target_count);
            for (n = 0; n < 8; ++n) {
                byteArrayOutputStream.write(this.targets[n].getFlags());
                byteArrayOutputStream.write(this.targets[n].getTrigger());
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.targets[n].getUrl(), 256));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_HTTPREQ, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objInput);
        for (n = 0; n < 10; ++n) {
            bMXJobData.addEIBAddressObject2(this.objValue[n]);
        }
        bMXJobData.addEIBAddressObject2(this.objErrorTxt);
        bMXJobData.addEIBAddressObject2(this.objResult);
        for (n = 0; n < 4; ++n) {
            bMXJobData.addEIBAddressObject2(this.objOutput[n]);
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "total_timeout: \t" + this.total_timeout + "\n";
        string2 = string2 + "max_size_k: \t" + this.max_size_k + "\n";
        string2 = string2 + "protocol: \t" + this.protocol + "\n";
        string2 = string2 + "baseURL: \t" + this.baseURL + "\n";
        string2 = string2 + "auth_name: \t" + this.auth_name + "\n";
        string2 = string2 + "auth_passwd: \t" + this.auth_passwd + "\n";
        string2 = string2 + "proxy_url: \t" + this.proxy_url + "\n";
        string2 = string2 + "proxy_name: \t" + this.proxy_name + "\n";
        string2 = string2 + "proxy_passwd: \t" + this.proxy_passwd + "\n";
        string2 = string2 + "useragent: \t" + this.useragent + "\n";
        string2 = string2 + "request_type: \t" + this.requestType + "\n";
        string2 = string2 + "ca_file: \t" + this.ca_file + "\n";
        string2 = string2 + "cert_file: \t" + this.cert_file + "\n";
        string2 = string2 + "additional_headers: \t" + this.additional_headers + "\n";
        for (BMXValueModel object : this.value_format) {
            string2 = string2 + JOBS_EIS_TO_STRING[object.getEis()] + "\n";
            string2 = string2 + "flags: " + object.getFlags() + "\n";
            string2 = string2 + "trigger: " + object.getTrigger_eis14() + "\n";
            string2 = string2 + "factor: " + object.getFactor() + "\n";
            string2 = string2 + "offset: " + object.getOffset() + "\n";
            string2 = string2 + "format: " + object.getFormat() + "\n";
        }
        string2 = string2 + "result_eis: \t" + this.result_eis + "\n";
        string2 = string2 + "target_count: \t" + this.target_count + "\n";
        for (HttpReqTargetModel httpReqTargetModel : this.targets) {
            string2 = string2 + httpReqTargetModel.getUrl() + "\n";
        }
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        string2 = string2 + "input: \t" + this.objInput.getAddressObjectAsString() + "\n";
        for (EIBAddressObject2 eIBAddressObject2 : this.objValue) {
            string2 = string2 + "value: \t" + eIBAddressObject2.getAddressObjectAsString() + "\n";
        }
        string2 = string2 + "error: \t" + this.objErrorTxt.getAddressObjectAsString() + "\n";
        string2 = string2 + "result: \t" + this.objResult.getAddressObjectAsString() + "\n";
        for (EIBAddressObject2 eIBAddressObject2 : this.objOutput) {
            if (eIBAddressObject2 == null) continue;
            string2 = string2 + "output: \t" + eIBAddressObject2.getAddressObjectAsString() + "\n";
        }
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public boolean getCompileFlag(int n) {
        return (this.compile_flags & n) != 0;
    }

    public void setCompileFlag(int n, boolean bl) {
        this.compile_flags = bl ? (this.compile_flags |= n) : (this.compile_flags &= ~n);
    }

    public boolean getExecFlag(int n) {
        return (this.exec_flags & n) != 0;
    }

    public void setExecFlag(int n, boolean bl) {
        this.exec_flags = bl ? (this.exec_flags |= n) : (this.exec_flags &= ~n);
    }

    public int getTotal_timeout() {
        return this.total_timeout;
    }

    public void setTotal_timeout(int n) {
        this.total_timeout = n;
    }

    public int getMax_size_k() {
        return this.max_size_k;
    }

    public void setMax_size_k(int n) {
        this.max_size_k = n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public String getAuth_name() {
        return this.auth_name;
    }

    public void setAuth_name(String string) {
        this.auth_name = string;
    }

    public String getAuth_passwd() {
        return this.auth_passwd;
    }

    public void setAuth_passwd(String string) {
        this.auth_passwd = string;
    }

    public String getProxy_url() {
        return this.proxy_url;
    }

    public void setProxy_url(String string) {
        this.proxy_url = string;
    }

    public String getProxy_name() {
        return this.proxy_name;
    }

    public void setProxy_name(String string) {
        this.proxy_name = string;
    }

    public String getProxy_passwd() {
        return this.proxy_passwd;
    }

    public void setProxy_passwd(String string) {
        this.proxy_passwd = string;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String string) {
        this.useragent = string;
    }

    public byte getRequestType() {
        return this.requestType;
    }

    public void setRequestType(byte by) {
        this.requestType = by;
    }

    public String getCa_file() {
        return this.ca_file;
    }

    public void setCa_file(String string) {
        this.ca_file = string;
    }

    public String getCert_file() {
        return this.cert_file;
    }

    public void setCert_file(String string) {
        this.cert_file = string;
    }

    public String getAdditional_headers() {
        return this.additional_headers;
    }

    public void setAdditional_headers(String string) {
        this.additional_headers = string;
    }

    public BMXValueModel[] getValue_format() {
        return this.value_format;
    }

    public void setValue_format(BMXValueModel[] bMXValueModelArray) {
        this.value_format = bMXValueModelArray;
    }

    public byte getResult_eis() {
        return this.result_eis;
    }

    public void setResult_eis(byte by) {
        this.result_eis = by;
    }

    public byte getOutput_implementation() {
        return this.former_output_implementation;
    }

    public void setOutput_implementation(byte by) {
        this.former_output_implementation = by;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public long getCompile_flags() {
        return this.compile_flags;
    }

    public void setCompile_flags(int n) {
        this.compile_flags = n;
    }

    public long getExec_flags() {
        return this.exec_flags;
    }

    public void setExec_flags(int n) {
        this.exec_flags = n;
    }

    public HttpReqOutputModel[] getOutputs() {
        return this.outputs;
    }

    public void setOutputs(HttpReqOutputModel[] httpReqOutputModelArray) {
        this.outputs = httpReqOutputModelArray;
    }

    public byte getTarget_count() {
        return this.target_count;
    }

    public void setTarget_count(byte by) {
        this.target_count = by;
    }

    public HttpReqTargetModel[] getTargets() {
        return this.targets;
    }

    public void setTargets(HttpReqTargetModel[] httpReqTargetModelArray) {
        this.targets = httpReqTargetModelArray;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjInput() {
        return this.objInput;
    }

    public void setObjInput(EIBAddressObject2 eIBAddressObject2) {
        this.objInput = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjValue() {
        return this.objValue;
    }

    public void setObjValue(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objValue = eIBAddressObject2Array;
    }

    public EIBAddressObject2 getObjErrorTxt() {
        return this.objErrorTxt;
    }

    public void setObjErrorTxt(EIBAddressObject2 eIBAddressObject2) {
        this.objErrorTxt = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjResult() {
        return this.objResult;
    }

    public void setObjResult(EIBAddressObject2 eIBAddressObject2) {
        this.objResult = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objOutput = eIBAddressObject2Array;
    }
}

