/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.onewire;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BMXOneWire
extends BMXJobModel {
    public static final int JOBS_OW_DEVICE_COUNT = 8;
    public static final int JOBS_OW_VERSION1_EOS_RESERVED = 12;
    public static final int JOBS_OW_OBMAX = 29;
    public static final int JOBS_OW_FLAGS_NONE = 0;
    public static final int JOBS_OW_FLAGS_ALL = 0;
    public static final int JOBS_OW_ACTUAL_VERSION = 1;
    public static final int JOBS_OW_VERSION1_DEVICE_RESERVED = 32;
    public static final int JOBS_OW_VERSION1_JOB_RESERVED = 128;
    public static final int JOBS_OW_DEFAULT_POLL_INTERVAL = 20;
    public static final int JOBS_OW_DEVICE_FLAG_CYCLIC_PRESENCE = 1;
    public static final int JOBS_OW_DEVICE_FORMAT_PRESENCE = 1;
    public static final int JOBS_OW_DEVICE_FORMAT_TEMPERATURE = 2;
    public static final int JOBS_OW_DEVICE_FORMAT_HUMIDITY_HIH3600 = 3;
    public static final int JOBS_OW_DEVICE_FORMAT_HUMIDITY_HIH4000 = 4;
    public static final int JOBS_OW_DEVICE_FORMAT_HUMIDITY_HTM1735 = 5;
    public static final int JOBS_OW_DEVICE_FORMAT_PRESSURE_B1R1A = 6;
    public static final int JOBS_OW_DEVICE_FORMAT_ILLUMINANCE_S3R1A = 7;
    public static final int JOBS_OW_DEVICE_FORMAT_VAD = 8;
    public static final int JOBS_OW_DEVICE_FORMAT_VDD = 9;
    public static final int JOBS_OW_DEVICE_FORMAT_VIS = 10;
    public static final int JOBS_OW_DEVICE_FORMAT_HUMIDITY = 11;
    public static final int JOBS_OW_DEVICE_FORMAT_DEWPOINT_EDS0068 = 12;
    public static final int JOBS_OW_DEVICE_FORMAT_HEAT_INDEX_EDS0068 = 13;
    public static final int JOBS_OW_DEVICE_FORMAT_HUMIDEX_EDS0068 = 14;
    public static final int JOBS_OW_DEVICE_FORMAT_HUMIDITY_EDS0068 = 15;
    public static final int JOBS_OW_DEVICE_FORMAT_INHG_EDS0068 = 16;
    public static final int JOBS_OW_DEVICE_FORMAT_LIGHT_EDS0068 = 17;
    public static final int JOBS_OW_DEVICE_FORMAT_PRESSURE_EDS0068 = 18;
    public static final int JOBS_OW_DEVICE_FORMAT_TEMPERATURE_EDS0068 = 19;
    private int flags;
    private int version = 1;
    private int devCount;
    private ArrayList<BMXOneWireDevice> devices = new ArrayList(8);
    private EIBAddressObject2 objEnable;

    public BMXOneWire(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public static long invertLong(long l) {
        return (l & 0xFFL) << 40 | (l >> 8 & 0xFFL) << 32 | (l >> 16 & 0xFFL) << 24 | (l >> 24 & 0xFFL) << 16 | (l >> 32 & 0xFFL) << 8 | l >> 40 & 0xFFL;
    }

    public BMXOneWire() {
        for (int i = 0; i < 8; ++i) {
            this.devices.add(new BMXOneWireDevice());
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++] & 0xFF;
        this.version = byArray[n2++] & 0xFF;
        int n3 = byArray[n2++] & 0xFF;
        for (n = 0; n < n3; ++n) {
            BMXOneWireDevice bMXOneWireDevice = this.getDevice(n);
            bMXOneWireDevice.flags = byArray[n2++] & 0xFF;
            bMXOneWireDevice.format = byArray[n2++] & 0xFF;
            bMXOneWireDevice.eisAbsent = byArray[n2++] & 0xFF;
            bMXOneWireDevice.eisPresent = byArray[n2++] & 0xFF;
            bMXOneWireDevice.dataAbsent = byArray[n2++] & 0xFF;
            bMXOneWireDevice.dataPresent = byArray[n2++] & 0xFF;
            bMXOneWireDevice.family = byArray[n2++] & 0xFF;
            bMXOneWireDevice.skipCount = ByteConv.byte2short(byArray, n2);
            bMXOneWireDevice.id = ByteConv.byte2long64(byArray, n2 += 2);
            n2 += 8;
            n2 += 32;
        }
        n2 += 128;
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        for (int i = 0; i < 8; ++i) {
            BMXOneWireDevice bMXOneWireDevice = this.getDevice(i);
            bMXOneWireDevice.objAbsent = bMXJobData.getEIBAddressObject2(n);
            bMXOneWireDevice.objPresent = bMXJobData.getEIBAddressObject2(n + 8);
            ++n;
        }
        n += 12;
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.flags);
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(this.devCount);
            for (int i = 0; i < 8; ++i) {
                BMXOneWireDevice bMXOneWireDevice = this.getDevice(i);
                byteArrayOutputStream.write(bMXOneWireDevice.flags);
                byteArrayOutputStream.write(bMXOneWireDevice.format);
                byteArrayOutputStream.write(bMXOneWireDevice.eisAbsent);
                byteArrayOutputStream.write(bMXOneWireDevice.eisPresent);
                byteArrayOutputStream.write(bMXOneWireDevice.dataAbsent);
                byteArrayOutputStream.write(bMXOneWireDevice.dataPresent);
                byteArrayOutputStream.write(bMXOneWireDevice.family);
                byteArrayOutputStream.write(ByteConv.short2byte(bMXOneWireDevice.skipCount));
                byteArrayOutputStream.write(ByteConv.long2byte64(bMXOneWireDevice.id));
                byteArrayOutputStream.write(new byte[32]);
            }
            byteArrayOutputStream.write(new byte[128]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_ONEWIRE, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        for (n = 0; n < 8; ++n) {
            bMXJobData.addEIBAddressObject2(this.devices.get(n).objAbsent);
        }
        for (n = 0; n < 8; ++n) {
            bMXJobData.addEIBAddressObject2(this.devices.get(n).objPresent);
        }
        for (n = 0; n < 12; ++n) {
            bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? this.flags | n : this.flags & ~n;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) > 0;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void setDevCount(int n) {
        this.devCount = n;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public int getDeviceCount() {
        return this.devices.size();
    }

    public BMXOneWireDevice getDevice(int n) {
        return this.devices.get(n);
    }

    public class BMXOneWireDevice {
        private int flags;
        private int format;
        private int eisAbsent;
        private int eisPresent;
        private int dataAbsent;
        private int dataPresent;
        private int family;
        private int skipCount;
        private long id;
        private EIBAddressObject2 objAbsent;
        private EIBAddressObject2 objPresent;

        private BMXOneWireDevice() {
        }

        public void setFlag(int n, boolean bl) {
            this.flags = bl ? this.flags | n : this.flags & ~n;
        }

        public boolean getFlag(int n) {
            return (this.flags & n) > 0;
        }

        public int getFormat() {
            return this.format;
        }

        public void setFormat(int n) {
            this.format = n;
        }

        public int getEisAbsent() {
            return this.eisAbsent;
        }

        public void setEisAbsent(int n) {
            this.eisAbsent = n;
        }

        public int getEisPresent() {
            return this.eisPresent;
        }

        public void setEisPresent(int n) {
            this.eisPresent = n;
        }

        public int getDataPresent() {
            return this.dataPresent;
        }

        public void setDataPresent(int n) {
            this.dataPresent = n;
        }

        public int getDataAbsent() {
            return this.dataAbsent;
        }

        public void setDataAbsent(int n) {
            this.dataAbsent = n;
        }

        public int getSkipCount() {
            return this.skipCount;
        }

        public void setSkipCount(int n) {
            this.skipCount = n;
        }

        public int getFamily() {
            return this.family;
        }

        public void setFamily(int n) {
            this.family = n;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long l) {
            this.id = l;
        }

        public EIBAddressObject2 getObjAbsent() {
            return this.objAbsent;
        }

        public void setObjAbsent(EIBAddressObject2 eIBAddressObject2) {
            this.objAbsent = eIBAddressObject2;
        }

        public EIBAddressObject2 getObjPresent() {
            return this.objPresent;
        }

        public void setObjPresent(EIBAddressObject2 eIBAddressObject2) {
            this.objPresent = eIBAddressObject2;
        }
    }
}

