/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.smsrecv;

import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXSmsReceiverPattern {
    public static final int JOBS_SMSR_PATTERN_SIZE = 256;
    public static final int JOBS_SMSR_PATTERN_FLAG_CASE_INSENSITIVE = 1;
    public static final int JOBS_SMSR_PATTERN_FLAG_FIND_ANYWHERE = 2;
    public static final int JOBS_SMSR_PATTERN_FLAG_ACTIVE = 4;
    private int flags;
    private int data;
    private int format;
    private String pattern;

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        this.flags &= ~n;
        if (bl) {
            this.flags |= n;
        }
    }

    public int getData() {
        return this.data;
    }

    public void setData(int n) {
        this.data = n;
    }

    public void setEis(int n) {
        this.format = n;
    }

    public int getEis() {
        return this.format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public int setBMXJobData(byte[] byArray, int n) {
        int n2 = n;
        this.setFlags(byArray[n2++] & 0xFF);
        this.setData(byArray[n2++] & 0xFF);
        n2 += 15;
        this.setEis(byArray[n2++] & 0xFF);
        this.setPattern(ByteConv.byte2string(byArray, ++n2, 256));
        return (n2 += 256) - n;
    }

    public void getJobData(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byteArrayOutputStream.write(this.getFlags());
        byteArrayOutputStream.write(this.getData());
        byteArrayOutputStream.write(new byte[15]);
        byteArrayOutputStream.write(this.getEis());
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.getPattern(), 256));
    }
}

