/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.smssnd;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.BMXValueModel;
import de.babtec.globals.jobdata.jobs.smssnd.BMXGSMPhone;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;

public class BMXSmsSenderModel
extends BMXJobModel {
    public static final int JOBS_SMSS_MAX_VALUES = 8;
    public static final int JOBS_SMSS_MAX_PHONES = 4;
    public static final int JOBS_SMSS_MAX_REPLACEMENTS = 9;
    public static final int JOBS_SMSS_OBMAX = 12;
    public static final int JOBS_SMSS_MAX_TEXT_LEN = 1024;
    public static final int JOBS_SMSS_VERSION = 1;
    public static final int JOBS_SMSS_RESERVED_BYTES_IN_V1 = 256;
    public static final int JOBS_SMSS_RESERVED_EOS_IN_V1 = 4;
    public static final int JOBS_SMSS_FLAG_SUM_STATUS_REPORT = 1;
    public static final int JOBS_SMSS_FLAG_TRY_MULTIPART_SMS = 2;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objStart;
    private EIBAddressObject2 objResult1;
    private EIBAddressObject2 objResult2;
    private EIBAddressObject2[] objInput = new EIBAddressObject2[8];
    private EIBAddressObject2[] objPhones = new EIBAddressObject2[4];
    private EIBAddressObject2[] objReserved = new EIBAddressObject2[4];
    private int version;
    private int flags;
    private BMXGSMPhone[] phones = new BMXGSMPhone[4];
    private BMXValueModel[] values = new BMXValueModel[8];
    private String text;
    private int encoding;
    private int maxRetries;
    private int maxLifetime;
    private int gsmValidityPeriod;
    private int result1Format;
    private int result2Format;
    private int rateMax;
    private int rateTime;

    public BMXSmsSenderModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXSmsSenderModel() {
        int n;
        for (n = 0; n < this.phones.length; ++n) {
            this.phones[n] = new BMXGSMPhone();
        }
        for (n = 0; n < this.values.length; ++n) {
            this.values[n] = new BMXValueModel();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.version = byArray[n2++] & 0xFF;
        this.flags = byArray[n2++] & 0xFF;
        for (n = 0; n < this.phones.length; ++n) {
            n2 += this.phones[n].setBMXJobData(byArray, n2);
        }
        for (n = 0; n < this.values.length; ++n) {
            n2 += this.values[n].setBMXJobData(byArray, n2);
        }
        this.text = ByteConv.byte2string(byArray, n2, 1024);
        this.encoding = ByteConv.byte2short(byArray, n2 += 1024);
        this.maxRetries = ByteConv.byte2short(byArray, n2 += 2);
        this.maxLifetime = ByteConv.byte2short(byArray, n2 += 2);
        this.gsmValidityPeriod = ByteConv.byte2short(byArray, n2 += 2);
        this.result1Format = byArray[n2 += 2] & 0xFF;
        this.result2Format = byArray[n2] & 0xFF;
        this.rateMax = ByteConv.byte2short(byArray, n2);
        this.rateTime = ByteConv.byte2short(byArray, n2 += 2);
        n2 += 2;
        n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        this.objStart = bMXJobData.getEIBAddressObject2(n2++);
        this.objResult1 = bMXJobData.getEIBAddressObject2(n2++);
        this.objResult2 = bMXJobData.getEIBAddressObject2(n2++);
        for (n = 0; n < 8; ++n) {
            this.objInput[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        for (n = 0; n < 4; ++n) {
            this.objPhones[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        for (n = 0; n < 4; ++n) {
            this.objReserved[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(this.flags);
            for (n2 = 0; n2 < this.phones.length; ++n2) {
                this.phones[n2].getJobData(byteArrayOutputStream);
            }
            for (n2 = 0; n2 < this.values.length; ++n2) {
                this.values[n2].getJobData(byteArrayOutputStream);
            }
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.text, 1024));
            byteArrayOutputStream.write(ByteConv.short2byte(this.encoding));
            byteArrayOutputStream.write(ByteConv.short2byte(this.maxRetries));
            byteArrayOutputStream.write(ByteConv.short2byte(this.maxLifetime));
            byteArrayOutputStream.write(ByteConv.short2byte(this.gsmValidityPeriod));
            byteArrayOutputStream.write(this.result1Format);
            byteArrayOutputStream.write(this.result2Format);
            byteArrayOutputStream.write(ByteConv.short2byte(this.rateMax));
            byteArrayOutputStream.write(ByteConv.short2byte(this.rateTime));
            byteArrayOutputStream.write(new byte[256]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_SMS_SENDER, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objStart);
        bMXJobData.addEIBAddressObject2(this.objResult1);
        bMXJobData.addEIBAddressObject2(this.objResult2);
        for (n = 0; n < 8; ++n) {
            bMXJobData.addEIBAddressObject2(this.objInput[n]);
        }
        for (n = 0; n < 4; ++n) {
            bMXJobData.addEIBAddressObject2(this.objPhones[n]);
        }
        for (n = 0; n < 4; ++n) {
            bMXJobData.addEIBAddressObject2(this.objReserved[n]);
        }
        return bMXJobData;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStart() {
        return this.objStart;
    }

    public void setObjStart(EIBAddressObject2 eIBAddressObject2) {
        this.objStart = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjResult1() {
        return this.objResult1;
    }

    public void setObjResult1(EIBAddressObject2 eIBAddressObject2) {
        this.objResult1 = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjResult2() {
        return this.objResult2;
    }

    public void setObjResult2(EIBAddressObject2 eIBAddressObject2) {
        this.objResult2 = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjInput(int n) {
        return this.objInput[n];
    }

    public void setObjInput(int n, EIBAddressObject2 eIBAddressObject2) {
        this.objInput[n] = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjPhone(int n) {
        return this.objPhones[n];
    }

    public void setObjPhone(int n, EIBAddressObject2 eIBAddressObject2) {
        this.objPhones[n] = eIBAddressObject2;
    }

    public BMXGSMPhone getPhone(int n) {
        return this.phones[n];
    }

    public BMXValueModel getValue(int n) {
        return this.values[n];
    }
}

