/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.usender;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.usender.Bfrule;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;

public class USenderModel
extends BMXJobModel {
    public static final int MAX_RULES_PER_JOB = 10;
    public static final int MAX_HOSTNAME_LEN = 32;
    private EIBAddressObject2 objEnable;
    private boolean resolveHost = false;
    private boolean resolveAlways = false;
    private boolean allowLoopbacks = false;
    private String host = "";
    private int port = 1735;
    private int targetSystemId = 0;
    private Bfrule[] bfrules = new Bfrule[10];

    public USenderModel(BMXJobData bMXJobData) {
        for (int i = 0; i < this.bfrules.length; ++i) {
            this.bfrules[i] = new Bfrule();
        }
        this.setBMXJobData(bMXJobData);
    }

    public USenderModel() {
        for (int i = 0; i < this.bfrules.length; ++i) {
            this.bfrules[i] = new Bfrule();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        byte[] byArray = bMXJobData.getParam();
        byte by = byArray[0];
        this.resolveAlways = (by & 1) > 0;
        this.allowLoopbacks = (by & 4) > 0;
        this.resolveHost = (by & 0x10) > 0;
        this.port = ByteConv.byte2short(byArray, 18);
        this.host = ByteConv.byte2string(byArray, 20 + 10 * Bfrule.getRawSize(), 32);
        for (int i = 0; i < 10; ++i) {
            this.bfrules[i].parseRaw(byArray, 20 + i * Bfrule.getRawSize());
        }
        this.targetSystemId = ByteConv.byte2short(byArray, 20 + 10 * Bfrule.getRawSize() + 32);
    }

    @Override
    public BMXJobData getJobData() {
        byte[] byArray = new byte[20 + 10 * Bfrule.getRawSize() + 32 + 2];
        int n = 0;
        if (this.resolveAlways) {
            n |= 1;
        }
        if (this.allowLoopbacks) {
            n |= 4;
        }
        if (this.resolveHost) {
            n |= 0x10;
        }
        byArray[0] = (byte)n;
        ByteConv.short2byteIP(this.port, byArray, 18);
        int n2 = 0;
        for (int i = 0; i < 10 && !this.bfrules[i].isEmpty(); ++i) {
            System.arraycopy(this.bfrules[i].getRaw(), 0, byArray, 20 + i * Bfrule.getRawSize(), Bfrule.getRawSize());
            ++n2;
        }
        ByteConv.string2byteIP(this.host, 32, byArray, 20 + 10 * Bfrule.getRawSize());
        ByteConv.short2byteIP(this.targetSystemId, byArray, 20 + 10 * Bfrule.getRawSize() + 32);
        BMXJobData bMXJobData = new BMXJobData(BMXJobList.LIBID_USENDER, this.name, true, byArray);
        bMXJobData.addEIBAddressObject2(this.objEnable);
        return bMXJobData;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public boolean isResolveHost() {
        return this.resolveHost;
    }

    public void setResolveHost(boolean bl) {
        this.resolveHost = bl;
    }

    public boolean isResolveAlways() {
        return this.resolveAlways;
    }

    public void setResolveAlways(boolean bl) {
        this.resolveAlways = bl;
    }

    public boolean isAllowLoopbacks() {
        return this.allowLoopbacks;
    }

    public void setAllowLoopbacks(boolean bl) {
        this.allowLoopbacks = bl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getTargetSystemId() {
        return this.targetSystemId;
    }

    public void setTargetSystemId(int n) {
        this.targetSystemId = n;
    }

    public Bfrule getBfrule(int n) {
        return this.bfrules[n];
    }
}

