/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import de.babtec.matrix.DongleProtect;
import de.babtec.matrix.Utils;
import de.babtec.matrix.exceptions.DPParseException;
import de.babtec.matrix.exceptions.DPReadException;
import de.babtec.matrix.exceptions.DongleProtectException;
import de.babtec.updatetool.Ep2UpdateController;
import de.babtec.updatetool.UpdateListenerAdapter;
import de.babtec.updatetool.UpdateTool;
import de.babtec.updatetool.discovery.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Ep2PreparationPanel
extends JPanel {
    private JPasswordField inputSshString;
    private JTextField inputUsername;
    private JPasswordField inputPassword;
    private JTextArea outputStatus;
    private JButton btnSubmit;
    private Ep2UpdateController controller;
    private Device device;

    public Ep2PreparationPanel(Ep2UpdateController ep2UpdateController) {
        this.controller = ep2UpdateController;
        this.setBorder(BorderFactory.createTitledBorder(UpdateTool.messages.getString("PreparationPanel.title")));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.ssh_string")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        this.inputSshString = new JPasswordField();
        jPanel.add((Component)this.inputSshString, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.username")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        this.inputUsername = new JTextField("admin");
        this.inputUsername.setEditable(false);
        jPanel.add((Component)this.inputUsername, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.password")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        this.inputPassword = new JPasswordField();
        jPanel.add((Component)this.inputPassword, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 7;
        this.btnSubmit = new JButton(UpdateTool.messages.getString("PreparationPanel.btn_start"));
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Ep2PreparationPanel.this.startPreparation();
            }
        });
        jPanel.add((Component)this.btnSubmit, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.status")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 10;
        this.outputStatus = new JTextArea();
        this.outputStatus.setEditable(false);
        jPanel.add((Component)new JScrollPane(this.outputStatus), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        ep2UpdateController.addUpdateListener(new UpdateListenerAdapter(){

            @Override
            public void preparationConnecting() {
                Ep2PreparationPanel.this.appendStatusMessage(UpdateTool.messages.getString("PreparationPanel.status.connecting"));
            }

            @Override
            public void preparationLoggingIn() {
                Ep2PreparationPanel.this.appendStatusMessage(UpdateTool.messages.getString("PreparationPanel.status.logging_in"));
            }

            @Override
            public void preparationInstallingRescueSystem() {
                Ep2PreparationPanel.this.appendStatusMessage(UpdateTool.messages.getString("PreparationPanel.status.installing_rescue"));
            }

            @Override
            public void preparationRebootInResuceMode() {
                Ep2PreparationPanel.this.appendStatusMessage(UpdateTool.messages.getString("PreparationPanel.status.rebooting"));
            }

            @Override
            public void preparationError(String string) {
                Ep2PreparationPanel.this.appendStatusMessage(UpdateTool.messages.getString("PreparationPanel.status.error") + string);
                Ep2PreparationPanel.this.inputSshString.setEnabled(true);
                Ep2PreparationPanel.this.inputPassword.setEnabled(true);
                Ep2PreparationPanel.this.btnSubmit.setEnabled(true);
            }
        });
    }

    private void appendStatusMessage(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ep2PreparationPanel.this.outputStatus.append(string + "\n");
            }
        });
    }

    private void startPreparation() {
        this.outputStatus.setText("");
        this.inputSshString.setEnabled(false);
        this.inputPassword.setEnabled(false);
        this.btnSubmit.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                final int n = Ep2PreparationPanel.this.controller.startPreparation(Ep2PreparationPanel.this.device, new String(Ep2PreparationPanel.this.inputSshString.getPassword()), new String(Ep2PreparationPanel.this.inputPassword.getPassword()));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ep2PreparationPanel.this.preparationFinished(n);
                    }
                });
            }
        }.start();
    }

    private void preparationFinished(int n) {
        String string = "Unknown error";
        int n2 = 1;
        switch (n) {
            case 2: {
                int n3 = this.device.getLastDatagram().getBody().getPropertyShort("bPortSsh") & 0xFFFF;
                string = UpdateTool.messages.getString("PreparationPanel.message.wrong_string").replace("%ssh_port%", Integer.toString(n3));
                n2 = 0;
                break;
            }
            case 3: {
                string = UpdateTool.messages.getString("PreparationPanel.message.wrong_passwd");
                n2 = 0;
                break;
            }
            case 1: {
                string = UpdateTool.messages.getString("PreparationPanel.message.success");
                n2 = 1;
            }
        }
        JOptionPane.showMessageDialog(this, string, "Update Preparation", n2);
    }

    public void setDevice(Device device) {
        if (device != null && this.device != null && this.device.equals(device)) {
            return;
        }
        this.device = device;
        boolean bl = device != null && device.isActive();
        this.inputSshString.setText("");
        this.inputPassword.setText("");
        this.outputStatus.setText("");
        this.inputSshString.setEnabled(bl);
        this.inputPassword.setEnabled(bl);
        this.btnSubmit.setEnabled(bl);
        if (bl) {
            DongleProtect dongleProtect = new DongleProtect();
            try {
                dongleProtect.init(null);
                boolean bl2 = dongleProtect.getProperty(1, 4);
                boolean bl3 = dongleProtect.getProperty(2, 4);
                int n = device.getLastDatagram().getBody().getPropertyInteger("bSernr");
                String string = new DecimalFormat("BT0000000000").format(n);
                if (Utils.isEibPortSernr(string) && bl2) {
                    this.inputPassword.setEnabled(false);
                    this.inputPassword.setText("00000000");
                }
                if (Utils.isIpcSernr(string) && bl3) {
                    this.inputPassword.setEnabled(false);
                    this.inputPassword.setText("00000000");
                }
            }
            catch (DPReadException dPReadException) {
            }
            catch (DPParseException dPParseException) {
                if (dPParseException.getError() == 1) {
                    JOptionPane.showMessageDialog(this, "This dongle expired. Please contact b.a.b-technologie gmbh to reactivate this dongle.");
                }
            }
            catch (DongleProtectException dongleProtectException) {
                // empty catch block
            }
        }
    }
}

