/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import de.babtec.globals.utils.ByteConv;
import de.babtec.updatetool.Ep2KeyStorageStatic;
import de.babtec.updatetool.UpdateListener;
import de.babtec.updatetool.discovery.Device;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import de.eibport.net.sftp.EibPortSftpException;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.net.sftp.SftpTransfer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.event.EventListenerList;

public abstract class UpdateController {
    protected static final int FCONT_MAGIC = 2114;
    protected static final int FCONT_VERSION = 257;
    protected static final int FCONT_FOOTER_ENTRY_TYPE_DIR = 42;
    protected static final int FCONT_FOOTER_ENTRY_TYPE_DUMMY = 1;
    protected static final int FCONT_MAX_DIR_ENTRIES = 16;
    protected static final int FCONT_MAX_FILENAME_LENGTH = 31;
    public static final int RET_PREP_OK = 1;
    public static final int RET_PREP_WRONG_STRING = 2;
    public static final int RET_PREP_WRONG_ADMIN_PASSWD = 3;
    public static final int RET_PREP_CONNECTION_ERROR = 4;
    public static final int RET_PREP_NO_LOGIN_AVAILABLE = 5;
    public static final int RET_TEST_INVALID_IMAGE = 1;
    public static final int RET_MD5_CHKSUM_OK = 1;
    public static final int RET_MD5_CHKSUM_ERROR = 2;
    public static final int RET_MD5_CHKSUM_FILE_NOT_FOUND = 3;
    public static final int RET_MD5_FW_FILE_NOT_FOUND = 4;
    public static final int RET_MD5_CHKSUM_UNABLE_TO_GENERATE = 5;
    public static final int RET_UPDATE_OK = 11;
    public static final int RET_BOOTSTRAP_AND_UPDATE_OK = 12;
    public static final int RET_UPDATE_CONNECTION_ERRROR = 13;
    public static final int RET_UPDATE_FILE_NOT_FOUND = 14;
    public static final String FILE_RESCUE_VERSION = "/config/rescue_version";
    public static final String FILE_START_RESCUE = "/config/START_RESCUE";
    public static final String FILE_UPDATE_FINISHED = "/home/bt1/ready";
    protected EventListenerList listener = new EventListenerList();
    protected DatagramSocket udpSocket = new DatagramSocket();

    public void addUpdateListener(UpdateListener updateListener) {
        this.listener.add(UpdateListener.class, updateListener);
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        this.listener.remove(UpdateListener.class, updateListener);
    }

    protected Cipher getCipher(int n) {
        byte[] byArray = new byte[]{-128, 3, -41, -107, 30, -67, -25, 93};
        byte[] byArray2 = new byte[]{13, 91, -10, -48, -111, 54, -78, 113};
        try {
            Cipher cipher = Cipher.getInstance("Blowfish/CFB8/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "Blowfish");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getRescueVersion(Device device) {
        String string = null;
        if (device.isInRescueMode()) {
            EpDatagram epDatagram = device.getLastDatagram();
            String string2 = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
            int n = epDatagram.getBody().getPropertyShort("bPortSsh") & 0xFFFF;
            int n2 = epDatagram.getBody().getPropertyShort("bPortBmx") & 0xFFFF;
            Ep2KeyStorageStatic ep2KeyStorageStatic = new Ep2KeyStorageStatic();
            SftpContainer sftpContainer = new SftpContainer(string2, n, ep2KeyStorageStatic);
            try {
                sftpContainer.init("2JX02fQqHz");
                SftpTransfer sftpTransfer = (SftpTransfer)sftpContainer.getFileInterface();
                InputStream inputStream = sftpTransfer.readFromFile("rescue_version", false);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string = bufferedReader.readLine();
                sftpTransfer.closeConnection();
            }
            catch (EibPortSftpException eibPortSftpException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {}
        } else {
            try {
                URL uRL = device.getURL("rescue_version");
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.setDoInput(true);
                InputStream inputStream = uRLConnection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string = bufferedReader.readLine();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public int compareMD5Checksum(String string) {
        String string2;
        String string3;
        try {
            string3 = this.getMD5Checksum(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return 5;
        }
        try {
            string2 = this.readMD5Checksum(string + ".md5");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 3;
        }
        if (!string3.equals(string2)) {
            return 2;
        }
        return 1;
    }

    private String readMD5Checksum(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = bufferedReader.readLine();
        return string2.substring(0, 32);
    }

    private String getMD5Checksum(String string) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        byte[] byArray = this.createChecksum(string);
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            string2 = string2 + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string2;
    }

    private byte[] createChecksum(String string) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((n = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n);
        } while (n != -1);
        ((InputStream)fileInputStream).close();
        return messageDigest.digest();
    }

    public String getTypeAndVersion(String string) {
        File file = new File(string);
        long l = file.length();
        if (l < 14L) {
            return null;
        }
        try {
            byte[] byArray;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray2 = new byte[16];
            randomAccessFile.seek((int)l - byArray2.length);
            randomAccessFile.read(byArray2, 0, byArray2.length);
            if (ByteConv.byte2short(byArray2, 0) != 2114) {
                System.out.println("MAGIC DOES NOT FIT!");
                return null;
            }
            if (ByteConv.byte2short(byArray2, 2) != 257) {
                System.out.println("VERSION DOES NOT FIT!");
                return null;
            }
            int n = ByteConv.byte2long(byArray2, 4);
            int n2 = ByteConv.byte2long(byArray2, 8);
            byte[] byArray3 = new byte[6];
            randomAccessFile.seek(n);
            randomAccessFile.read(byArray3, 0, byArray3.length);
            int n3 = ByteConv.byte2short(byArray3, 0);
            int n4 = ByteConv.byte2long(byArray3, 2);
            int n5 = -1;
            int n6 = -1;
            if (n3 == 42) {
                byArray = new byte[n4];
                randomAccessFile.read(byArray, 0, byArray.length);
                int n7 = 0;
                int n8 = byArray[n7++] & 0xFF;
                int n9 = byArray[n7++] & 0xFF;
                for (int i = 0; i < n9; ++i) {
                    int n10 = ByteConv.byte2long(byArray, n7);
                    int n11 = ByteConv.byte2long(byArray, n7 += 4);
                    String string2 = new String(byArray, n7 += 4, 32).trim();
                    n7 += 32;
                    if (!"info".equals(string2)) continue;
                    n5 = n10;
                    n6 = n11;
                }
            }
            if (n5 == -1 || n6 == -1) {
                return null;
            }
            randomAccessFile.seek(n5);
            byArray = new byte[n6];
            randomAccessFile.read(byArray, 0, n6);
            return new String(byArray).trim();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void startLedTest(Device device) throws IOException {
        EpDatagram epDatagram = device.getLastDatagram();
        String string = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        int n = epDatagram.getBody().getPropertyShort("bPortUdp") & 0xFFFF;
        EpDatagram epDatagram2 = EpDatagram.getControlDatagram((short)64, (byte)1, (short)0);
        this.sendUDP(epDatagram2, string, n);
    }

    public void sendUDP(EpDatagram epDatagram, String string, int n) throws IOException {
        byte[] byArray = epDatagram.getBytes();
        this.udpSocket.send(new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n));
    }

    class RestoreFile {
        String filename;
        int group = -1;
        int owner = -1;
        int permission = -1;

        RestoreFile() {
        }
    }
}

