/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.datechooser;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DateChooser
extends JDialog
implements ItemListener,
MouseListener,
FocusListener,
KeyListener,
ActionListener {
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final Color WEEK_DAYS_FOREGROUND = Color.black;
    private static final Color DAYS_FOREGROUND = Color.blue;
    private static final Color SELECTED_DAY_FOREGROUND = Color.white;
    private static final Color SELECTED_DAY_BACKGROUND = Color.blue;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.yellow, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private JLabel[][] days;
    private FocusablePanel daysGrid;
    private JComboBox month;
    private JComboBox year;
    private JButton ok;
    private JButton cancel;
    private int offset;
    private int lastDay;
    private JLabel day;
    private boolean okClicked;

    private void construct() {
        int n;
        int n2;
        this.calendar = new GregorianCalendar();
        this.month = new JComboBox<String>(MONTHS);
        this.month.addItemListener(this);
        this.year = new JComboBox();
        for (n2 = 1900; n2 <= 2100; ++n2) {
            this.year.addItem(Integer.toString(n2));
        }
        this.year.addItemListener(this);
        this.days = new JLabel[7][7];
        for (n2 = 0; n2 < 7; ++n2) {
            this.days[0][n2] = new JLabel(DAYS[n2], 4);
            this.days[0][n2].setForeground(WEEK_DAYS_FOREGROUND);
        }
        for (n2 = 1; n2 < 7; ++n2) {
            for (n = 0; n < 7; ++n) {
                this.days[n2][n] = new JLabel(" ", 4);
                this.days[n2][n].setForeground(DAYS_FOREGROUND);
                this.days[n2][n].setBackground(SELECTED_DAY_BACKGROUND);
                this.days[n2][n].setBorder(EMPTY_BORDER);
                this.days[n2][n].addMouseListener(this);
            }
        }
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.month);
        jPanel.add(this.year);
        this.daysGrid = new FocusablePanel(new GridLayout(7, 7, 5, 0));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        for (n = 0; n < 7; ++n) {
            for (int i = 0; i < 7; ++i) {
                this.daysGrid.add(this.days[n][i]);
            }
        }
        this.daysGrid.setBackground(Color.white);
        this.daysGrid.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.daysGrid);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.ok);
        jPanel3.add(this.cancel);
        Container container = this.getContentPane();
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        container.add("South", jPanel3);
        this.pack();
        this.setResizable(false);
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setSelected(JLabel jLabel) {
        if (this.day != null) {
            this.day.setForeground(DAYS_FOREGROUND);
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = jLabel;
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int n) {
        this.setSelected(this.days[(n + this.offset - 1) / 7 + 1][(n + this.offset - 1) % 7]);
    }

    private void update() {
        int n;
        int n2 = this.getSelectedDay();
        for (n = 0; n < 7; ++n) {
            this.days[1][n].setText(" ");
            this.days[5][n].setText(" ");
            this.days[6][n].setText(" ");
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.offset = this.calendar.get(7) - 1;
        this.lastDay = this.calendar.getActualMaximum(5);
        for (n = 0; n < this.lastDay; ++n) {
            this.days[(n + this.offset) / 7 + 1][(n + this.offset) % 7].setText(String.valueOf(n + 1));
        }
        if (n2 != -1) {
            if (n2 > this.lastDay) {
                n2 = this.lastDay;
            }
            this.setSelected(n2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.okClicked = true;
        }
        this.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setSelected(this.day);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setSelected(this.day);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.update();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = this.getSelectedDay();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (n <= 1) break;
                this.setSelected(n - 1);
                break;
            }
            case 39: {
                if (n >= this.lastDay) break;
                this.setSelected(n + 1);
                break;
            }
            case 38: {
                if (n <= 7) break;
                this.setSelected(n - 7);
                break;
            }
            case 40: {
                if (n > this.lastDay - 7) break;
                this.setSelected(n + 7);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        if (!jLabel.getText().equals(" ")) {
            this.setSelected(jLabel);
        }
        this.daysGrid.requestFocus();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public DateChooser(Dialog dialog, String string) {
        super(dialog, string, true);
        this.construct();
    }

    public DateChooser(Dialog dialog) {
        super(dialog, true);
        this.construct();
    }

    public DateChooser(Frame frame, String string) {
        super(frame, string, true);
        this.construct();
    }

    public DateChooser(Frame frame) {
        super(frame, true);
        this.construct();
    }

    public Date select(Date date) {
        this.calendar.setTime(date);
        int n = this.calendar.get(5);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(1);
        this.year.setSelectedIndex(n3 - 1900);
        this.month.setSelectedIndex(n2 - 0);
        this.setSelected(n);
        this.okClicked = false;
        this.setVisible(true);
        if (!this.okClicked) {
            return null;
        }
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        return this.calendar.getTime();
    }

    public Date select() {
        return this.select(new Date());
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }
    }
}

