/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.jtreetable;

import de.eibport.components.jtreetable.AbstractTreeTableModel;
import de.eibport.components.jtreetable.FileNode;
import de.eibport.components.jtreetable.TreeTableModel;
import java.io.File;
import java.util.Date;

public class FileSystemModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static String[] cNames = new String[]{"Name", "Size", "Type", "Modified"};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, Integer.class, String.class, Date.class};
    public static final Integer ZERO = new Integer(0);

    public FileSystemModel() {
        super(new FileNode(new File(File.separator)));
    }

    protected File getFile(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getFile();
    }

    protected Object[] getChildren(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getChildren();
    }

    @Override
    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getFile(object).isFile();
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return cNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        File file = this.getFile(object);
        try {
            switch (n) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? new Integer((int)file.length()) : ZERO;
                }
                case 2: {
                    return file.isFile() ? "File" : "Directory";
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }
}

