/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net;

import de.eibport.net.BasicHostInformation;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostInformation
extends BasicHostInformation {
    public static final String PATH_SERVLET_SECURITYMANAGER = "/webif/SecurityModule";
    public static final String PATH_SERVLET_UPNP_CONFIG = "/web.upnp/config.jsp";
    public static final String PATH_SERVLET_UPNP_RADIO = "/web.upnp/config_radio.jsp";
    private String PATH_YABUSRC = "/yabusrc";
    private String PATH_SERNR = "/tmp/sernr";
    private String PATH_FW_VERSION = "/fw_version";
    private String PATH_NAME = "/name";
    private String PATH_ENOCEAN_STATUS = "/enocean_status";

    public HostInformation(String string, int n) throws IOException {
        this("http", string, n, null);
    }

    public HostInformation(String string, String string2, int n, String string3) throws IOException {
        this.protocol = string;
        this.product = string3;
        if ("cvm".equals(string3)) {
            this.PATH_YABUSRC = "/info" + this.PATH_YABUSRC;
            this.PATH_SERNR = "/info/sernr";
            this.PATH_FW_VERSION = "/info/fw_version";
            this.PATH_NAME = "/info/name";
            this.PATH_ENOCEAN_STATUS = "/info/enocean_status";
        }
        this.loadPorts(string2, n);
        if ("https".equals(string)) {
            this.setHttpPort(443);
        }
    }

    private boolean loadPorts(String string, int n) throws IOException {
        BufferedReader bufferedReader;
        URL uRL;
        try {
            this.address = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.http_port = n == -1 ? 80 : n;
        try {
            uRL = new URL(this.protocol, string, n, this.PATH_YABUSRC);
            System.out.println("reading " + uRL);
            this.parseYabusrc(uRL.openConnection().getInputStream(), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            try {
                URL uRL2 = new URL(this.protocol, string, n, "/bxdrc");
                System.out.println("reading " + uRL2);
                return this.parseYabusrc(uRL2.openConnection().getInputStream(), true);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                fileNotFoundException2.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        try {
            uRL = new URL(this.getProtocol(), string, n, this.PATH_SERNR);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.sernr = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getClass() + ": " + iOException.getMessage());
        }
        try {
            uRL = new URL(this.getProtocol(), string, n, this.PATH_FW_VERSION);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.fwVersion = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getClass() + ": " + iOException.getMessage());
        }
        try {
            uRL = new URL(this.getProtocol(), string, n, this.PATH_NAME);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.epName = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getClass() + ": " + iOException.getMessage());
        }
        try {
            uRL = new URL(this.getProtocol(), string, n, this.PATH_ENOCEAN_STATUS);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.parseEnoceanStatus(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getClass() + ": " + iOException.getMessage());
        }
        return true;
    }

    public URL getBaseURL() {
        URL uRL = null;
        try {
            uRL = new URL(this.getProtocol(), this.address.getHostAddress(), this.http_port, "/");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public URL getURL(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        URL uRL = null;
        try {
            uRL = new URL(this.getProtocol(), this.address.getHostAddress(), this.http_port, string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public static int getComparableVersion(String string) {
        Pattern pattern = Pattern.compile(".*?(\\d*)\\.(\\d*).(\\d*)(?:-pre(\\d*))?");
        Matcher matcher = pattern.matcher(string);
        int n = 255;
        if (matcher.matches()) {
            n |= Integer.parseInt(matcher.group(1)) << 24;
            n |= Integer.parseInt(matcher.group(2)) << 16;
            n |= Integer.parseInt(matcher.group(3)) << 8;
            if (matcher.groupCount() > 4) {
                n |= Integer.parseInt(matcher.group(4));
            }
        }
        return n;
    }
}

