/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.jobs;

import de.babtec.globals.bmx.BMXPackets;
import de.babtec.globals.jobdata.BMXBasicJobData;
import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.LibID;
import de.eibport.net.bmx.BMXConnectionHandler;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.bmx.jobs.BMXJobReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BMXJobContainer
extends BMXListenerAdapter {
    private BMXConnectionHandler connectionHandler;
    private BMXJobList jobList;
    private boolean autoPossibilityFinished = false;
    private boolean autoListeFinished = false;
    private ArrayList<BMXBasicJobData> jobs = new ArrayList();
    private ArrayList<BMXJobReceiver> receivers = new ArrayList();

    public BMXJobContainer(BMXConnectionHandler bMXConnectionHandler) {
        this.connectionHandler = bMXConnectionHandler;
        this.jobList = new BMXJobList();
        this.connectionHandler.getBMXConnection().addBMXListener(this);
    }

    public void init() {
        this.jobs.clear();
        this.jobList.clear();
        this.connectionHandler.sendPacket(BMXPackets.constructAutoPossibility());
    }

    public void addReceiver(BMXJobReceiver bMXJobReceiver) {
        this.receivers.add(bMXJobReceiver);
    }

    public void removeReceiver(BMXJobReceiver bMXJobReceiver) {
        if (bMXJobReceiver != null && this.receivers.contains(bMXJobReceiver)) {
            this.receivers.remove(bMXJobReceiver);
        }
    }

    public ArrayList<BMXBasicJobData> getJobsByLibID(LibID libID, int n, int n2) {
        ArrayList<BMXBasicJobData> arrayList = new ArrayList<BMXBasicJobData>();
        for (BMXBasicJobData bMXBasicJobData : this.jobs) {
            LibID libID2 = bMXBasicJobData.getLibID();
            if (!libID2.equalsLibID(libID) || libID2.getVersion() < n || libID2.getVersion() > n2) continue;
            arrayList.add(bMXBasicJobData);
        }
        Collections.sort(arrayList, new Comparator<BMXBasicJobData>(){

            @Override
            public int compare(BMXBasicJobData bMXBasicJobData, BMXBasicJobData bMXBasicJobData2) {
                return bMXBasicJobData.getName().compareToIgnoreCase(bMXBasicJobData2.getName());
            }
        });
        return arrayList;
    }

    public BMXJobList getJobList() {
        return this.jobList;
    }

    public boolean autoPossibilityFinished() {
        return this.autoPossibilityFinished;
    }

    public boolean autoListeFinished() {
        return this.autoListeFinished;
    }

    public void outGetAutoItem(BMXBasicJobData bMXBasicJobData) {
        this.connectionHandler.sendPacket(BMXPackets.constructGetAutoItem(bMXBasicJobData));
    }

    public void outAddAutoItem(BMXJobData bMXJobData) {
        this.connectionHandler.sendPacket(BMXPackets.constructAddAutoItem(bMXJobData));
    }

    public void outStoreAutoItem(BMXJobData bMXJobData) {
        this.connectionHandler.sendPacket(BMXPackets.constructStoreAutoItem(bMXJobData));
    }

    public void outDeleteAutoItem(BMXBasicJobData bMXBasicJobData) {
        this.connectionHandler.sendPacket(BMXPackets.constructDeleteAutoItem(bMXBasicJobData));
    }

    @Override
    public void getAutoPossibility(LibID libID, String string) {
        if (libID.equalsAll(new LibID(0, 0, 0))) {
            this.connectionHandler.sendPacket(BMXPackets.constructAutoListe());
            this.autoPossibilityFinished = true;
            for (int i = 0; i < this.receivers.size(); ++i) {
                this.receivers.get(i).autoPossibilityFinished();
            }
        } else {
            this.jobList.getAutoPossibility(libID, string);
        }
    }

    @Override
    public void getAutoListe(BMXBasicJobData bMXBasicJobData) {
        if (bMXBasicJobData.getLibID().equalsAll(new LibID(0, 0, 0))) {
            if (bMXBasicJobData.getName().length() != 0) {
                return;
            }
            this.autoListeFinished = true;
            for (int i = 0; i < this.receivers.size(); ++i) {
                this.receivers.get(i).autoListeFinished();
            }
        } else {
            this.jobs.add(bMXBasicJobData);
        }
    }

    @Override
    public void getAutoItem(BMXJobData bMXJobData) {
        for (BMXJobReceiver bMXJobReceiver : this.receivers) {
            bMXJobReceiver.inGetAutoItem(bMXJobData);
        }
        this.fireAutoListeChanged();
    }

    @Override
    public void addAutoItem(byte[] byArray, String string) {
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        for (BMXJobReceiver bMXJobReceiver : this.receivers) {
            bMXJobReceiver.inAddAutoItem(n, string);
        }
        this.fireAutoListeChanged();
    }

    @Override
    public void storeAutoItem(byte[] byArray, String string) {
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        for (BMXJobReceiver bMXJobReceiver : this.receivers) {
            bMXJobReceiver.inStoreAutoItem(n, string);
        }
        this.fireAutoListeChanged();
    }

    @Override
    public void deleteAutoItem(byte[] byArray, String string) {
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        for (BMXJobReceiver bMXJobReceiver : this.receivers) {
            bMXJobReceiver.inDeleteAutoItem(n, string);
        }
        this.fireAutoListeChanged();
    }

    private void fireAutoListeChanged() {
        for (BMXJobReceiver bMXJobReceiver : this.receivers) {
            bMXJobReceiver.autoListeChanged();
        }
    }

    @Override
    public void changeAutoItem() {
        if (this.autoListeFinished) {
            this.autoListeFinished = false;
            this.jobs = new ArrayList();
            this.connectionHandler.sendPacket(BMXPackets.constructAutoListe());
        }
    }
}

