/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast;

import de.eibport.net.mcast.DatagramListener;
import de.eibport.net.mcast.DatagramListenerAdapter;
import de.eibport.net.mcast.MulticastThread;
import de.eibport.net.mcast.packets.v1.Beacon;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class EibPortList
extends JList {
    private MulticastThread mt;
    private DefaultListModel dlm;
    private HashSet<String> serialIndex = new HashSet();
    private Icon iconRescue;
    private DatagramListener dl = new DatagramListenerAdapter(){

        @Override
        public void receivedBeacon(final Beacon beacon) {
            if (!EibPortList.this.serialIndex.contains(beacon.toString())) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EibPortList.this.dlm.addElement(beacon);
                        EibPortList.this.serialIndex.add(beacon.toString());
                    }
                });
            }
        }

        @Override
        public void receivedBeacon(final EpDatagram epDatagram) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EibPortList.this.addDatagramToList(epDatagram);
                }
            });
        }
    };

    public EibPortList(MulticastThread multicastThread) {
        this.dlm = new DefaultListModel();
        this.setModel(this.dlm);
        this.mt = multicastThread;
        try {
            this.iconRescue = new ImageIcon(this.getClass().getResource("rescue.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof Beacon) {
                    component.setBackground(new Color(255, 148, 148));
                }
                if (object instanceof EpDatagram) {
                    switch (((EpDatagram)object).isReachable()) {
                        case 1: {
                            component.setBackground(new Color(148, 255, 148));
                            break;
                        }
                        case 0: {
                            component.setBackground(new Color(255, 255, 148));
                            break;
                        }
                        case 2: {
                            component.setBackground(new Color(192, 192, 192));
                        }
                    }
                    if (component instanceof JLabel && ((EpDatagram)object).isInRescueMode()) {
                        ((JLabel)component).setIcon(EibPortList.this.iconRescue);
                    }
                }
                return component;
            }
        });
    }

    private void addDatagramToList(EpDatagram epDatagram) {
        if (!this.serialIndex.contains(epDatagram.toString())) {
            epDatagram.testReachable(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EibPortList.this.repaint();
                }
            });
            this.dlm.addElement(epDatagram);
            this.revalidate();
            this.serialIndex.add(epDatagram.toString());
        }
    }

    public void startListening(short s) {
        this.mt.addListener(this.dl);
        this.mt.sendBytes(EpDatagram.getDiscoverDatagram(s).getBytes());
    }

    public void stopListening(boolean bl) {
        this.mt.removeListener(this.dl);
        if (bl) {
            this.dlm.removeAllElements();
            this.serialIndex.clear();
        }
    }
}

