/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast.packets.v1;

import de.eibport.net.mcast.packets.v1.BasicDatagram;
import de.eibport.net.mcast.packets.v1.DatagramHeader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;

public class Beacon
extends BasicDatagram {
    public static final int VS_MAJOR = 0;
    public static final int VS_MINOR = 1;
    public static final int VS_MICRO = 2;
    public static final int VS_PRE = 3;
    private int sernr;
    private int type;
    private int eibSysID;
    private String eibAddress;
    private String name;
    private String build;
    private InetAddress inetAdress;
    private int[] version = new int[4];

    public Beacon(DatagramHeader datagramHeader, byte[] byArray, int n) {
        super(datagramHeader);
        this.sernr = this.getInt(byArray, n);
        this.type = this.getShort(byArray, n + 4);
        this.eibSysID = this.getShort(byArray, n + 6);
        this.eibAddress = ((byArray[9 + n] & 0xF0) >> 4) + "." + (byArray[9 + n] & 0xF) + "." + (byArray[8 + n] & 0xFF);
        this.name = this.getString(byArray, 10 + n, 31);
        byte[] byArray2 = new byte[]{byArray[42 + n], byArray[43 + n], byArray[44 + n], byArray[45 + n]};
        this.version[0] = this.getInt(byArray, 46 + n);
        this.version[1] = this.getInt(byArray, 50 + n);
        this.version[2] = this.getInt(byArray, 54 + n);
        this.version[3] = this.getInt(byArray, 58 + n);
        try {
            this.inetAdress = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.build = this.getString(byArray, 62 + n, 31);
    }

    public int getSerialNr() {
        return this.sernr;
    }

    public String getSerialNrString() {
        return "BT" + new DecimalFormat("0000000000").format(this.getSerialNr());
    }

    public int getType() {
        return this.type;
    }

    public int getEibSysId() {
        return this.eibSysID;
    }

    public String getEibAddress() {
        return this.eibAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getBuild() {
        return this.build;
    }

    public InetAddress getInetAddress() {
        return this.inetAdress;
    }

    public int[] getVersion() {
        return this.version;
    }

    public int getVersion(int n) {
        return this.version[n];
    }

    public String getCompleteVersion() {
        return this.getVersion(0) + "." + this.getVersion(1) + "." + this.getVersion(2) + "." + (this.getVersion(3) == 0 ? "" : "pre") + this.getVersion(3);
    }

    public String toString() {
        return this.name + " (" + this.getSerialNrString() + ")";
    }

    public String getString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(31);
        for (int i = 0; i < n2 && byArray[n + i] != 0; ++i) {
            stringBuffer.append((char)byArray[n + i]);
        }
        return stringBuffer.toString();
    }

    public int getInt(byte[] byArray, int n) {
        int n2 = ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
        return n2;
    }

    public short getShort(byte[] byArray, int n) {
        short s = (short)(((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF));
        return s;
    }
}

