/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

public class BTLogger {
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_IMPORTANT = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_CRITICAL = 5;
    public static int DEBUG_LEVEL = 2;

    public static void setDebugLevel(int n) {
        DEBUG_LEVEL = n;
    }

    public static void log(int n, Class clazz, String string) {
        if (n >= DEBUG_LEVEL) {
            System.out.println(BTLogger.getLevelDescription(n) + " :: " + clazz + " :: " + string);
        }
    }

    public static void log(int n, String string) {
        if (n >= DEBUG_LEVEL) {
            System.out.println(BTLogger.getLevelDescription(n) + " :: " + string);
        }
    }

    public static void log(String string) {
        BTLogger.log(1, string);
    }

    public static void log(int n, Exception exception) {
        if (n >= DEBUG_LEVEL) {
            exception.printStackTrace();
        }
    }

    public static void log(Exception exception) {
        BTLogger.log(5, exception);
    }

    private static String getLevelDescription(int n) {
        switch (n) {
            case 5: {
                return "CRITICAL\t";
            }
            case 4: {
                return "ERROR\t";
            }
            case 3: {
                return "WARNING\t";
            }
            case 2: {
                return "IMPORTANT\t";
            }
            case 1: {
                return "INFO\t";
            }
        }
        return "";
    }
}

