/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

public class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class macOSErrorClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileType;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int WINDOWS_9x = 2;
    private static final int WINDOWS_NT = 3;
    private static final int LINUX = 4;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String NETSCAPE_OPEN_PARAMETER_START = " -remote openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")";
    private static String errorMessage;

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> clazz = Class.forName("com.apple.MacOS.AETarget");
                    macOSErrorClass = Class.forName("com.apple.MacOS.MacOSError");
                    Class<?> clazz2 = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> clazz3 = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> clazz4 = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = clazz.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = clazz3.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, clazz, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = clazz2.getDeclaredMethod("makeOSType", String.class);
                    putParameter = clazz3.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = clazz3.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field field = clazz4.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)field.get(null);
                    Field field2 = clazz3.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)field2.get(null);
                    Field field3 = clazz3.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)field3.get(null);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    errorMessage = noSuchFieldException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field field = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = field.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    errorMessage = noSuchFieldException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (SecurityException securityException) {
                    errorMessage = securityException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer n = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object t = aeTargetConstructor.newInstance(n);
                    Integer n2 = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object t2 = appleEventConstructor.newInstance(n2, n2, t, kAutoGenerateReturnID, kAnyTransactionID);
                    return t2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    browser = null;
                    errorMessage = illegalAccessException.getMessage();
                    return browser;
                }
                catch (InstantiationException instantiationException) {
                    browser = null;
                    errorMessage = instantiationException.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationTargetException) {
                    browser = null;
                    errorMessage = invocationTargetException.getMessage();
                    return browser;
                }
            }
            case 1: {
                File file;
                try {
                    file = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    browser = null;
                    errorMessage = illegalArgumentException.getMessage();
                    return browser;
                }
                catch (IllegalAccessException illegalAccessException) {
                    browser = null;
                    errorMessage = illegalAccessException.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationTargetException) {
                    browser = null;
                    errorMessage = invocationTargetException.getTargetException().getClass() + ": " + invocationTargetException.getTargetException().getMessage();
                    return browser;
                }
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        File file2 = new File(file, stringArray[i]);
                        if (!file2.isFile()) continue;
                        Object object = getFileType.invoke(null, file2);
                        if (!FINDER_TYPE.equals(object.toString())) continue;
                        browser = file2.toString();
                        return browser;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        errorMessage = illegalArgumentException.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        browser = null;
                        errorMessage = illegalAccessException.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        browser = null;
                        errorMessage = invocationTargetException.getTargetException().getClass() + ": " + invocationTargetException.getTargetException().getMessage();
                        return browser;
                    }
                }
                browser = null;
                break;
            }
            case 3: {
                browser = "cmd.exe";
                break;
            }
            case 2: {
                browser = "command.com";
                break;
            }
            case 4: {
                browser = "firefox";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String string) throws IOException {
        if (string == null) {
            return;
        }
        try {
            Desktop.getDesktop().browse(URI.create(string.toString()));
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (!loadedWithoutErrors) {
                throw new IOException("Exception in finding browser: " + errorMessage);
            }
            Object object = BrowserLauncher.locateBrowser();
            if (object == null) {
                throw new IOException("Unable to locate browser: " + errorMessage);
            }
            switch (jvm) {
                case 0: {
                    Object var2_3 = null;
                    try {
                        var2_3 = aeDescConstructor.newInstance(string);
                        putParameter.invoke(object, keyDirectObject, var2_3);
                        sendNoReply.invoke(object, new Object[0]);
                        break;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IOException("InvocationTargetException while creating AEDesc: " + invocationTargetException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IOException("IllegalAccessException while building AppleEvent: " + illegalAccessException.getMessage());
                    }
                    catch (InstantiationException instantiationException) {
                        throw new IOException("InstantiationException while creating AEDesc: " + instantiationException.getMessage());
                    }
                    finally {
                        var2_3 = null;
                        object = null;
                    }
                }
                case 1: {
                    Runtime.getRuntime().exec(new String[]{(String)object, string});
                    break;
                }
                case 2: 
                case 3: {
                    string = string.replace("&", "\"&\"");
                    Runtime.getRuntime().exec(new String[]{(String)object, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, string});
                    break;
                }
                case -1: {
                    Process process = Runtime.getRuntime().exec((String)object + NETSCAPE_OPEN_PARAMETER_START + string + NETSCAPE_OPEN_PARAMETER_END);
                    try {
                        int n = process.waitFor();
                        if (n == 0) break;
                        Runtime.getRuntime().exec(new String[]{(String)object, string});
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("InterruptedException while launching browser: " + interruptedException.getMessage());
                    }
                }
                default: {
                    Runtime.getRuntime().exec(new String[]{(String)object, string});
                }
            }
            return;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            BrowserLauncher.openURL("http://java.sun.com");
        } else {
            BrowserLauncher.openURL(stringArray[0]);
        }
    }

    static {
        block7: {
            loadedWithoutErrors = true;
            String string = System.getProperty("os.name");
            if ("Mac OS".equals(string)) {
                String string2 = System.getProperty("mrj.version");
                String string3 = string2.substring(0, 3);
                try {
                    double d = Double.valueOf(string3);
                    if (d == 2.0) {
                        jvm = 0;
                        break block7;
                    }
                    if (d >= 2.1) {
                        jvm = 1;
                        break block7;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + d;
                }
                catch (NumberFormatException numberFormatException) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + string2;
                }
            } else {
                jvm = string.startsWith("Windows") ? (string.indexOf("9") != -1 ? 2 : 3) : (string.startsWith("Linux") ? 4 : -1);
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

