/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DatePicker
extends JPanel {
    private JButton[] btn = new JButton[49];
    private int month = Calendar.getInstance().get(2);
    private int year = Calendar.getInstance().get(1);
    private JLabel lbl = new JLabel("", 0);
    private Date pickedDate;
    private ActionListener returnListener;

    public DatePicker(ActionListener actionListener) {
        this.returnListener = actionListener;
        this.buildGUI();
        this.setDates();
    }

    public void buildGUI() {
        this.setLayout(new BorderLayout());
        String[] stringArray = new String[]{"Mon", "Tue", "Wed", "Thur", "Fri", "Sat", "Sun"};
        JPanel jPanel = new JPanel(new GridLayout(7, 7));
        for (int i = 0; i < this.btn.length; ++i) {
            final int n = i;
            this.btn[i] = new JButton();
            this.btn[i].setContentAreaFilled(false);
            this.btn[i].setBackground(Color.WHITE);
            this.btn[i].setOpaque(true);
            this.btn[i].setFocusPainted(false);
            if (i > 6) {
                this.btn[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DatePicker.this.setDatePicked(DatePicker.this.btn[n].getActionCommand());
                    }
                });
            }
            if (i < 7) {
                this.btn[i].setForeground(Color.BLUE);
                this.btn[i].setText(stringArray[i]);
            }
            jPanel.add(this.btn[i]);
        }
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        JButton jButton = new JButton("<< Previous");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatePicker.this.month--;
                DatePicker.this.setDates();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(this.lbl);
        JButton jButton2 = new JButton("Next >>");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatePicker.this.month++;
                DatePicker.this.setDates();
            }
        });
        jPanel2.add(jButton2);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "North");
    }

    public void setDates() {
        for (int i = 7; i < this.btn.length; ++i) {
            this.btn[i].setText("");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM yyyy");
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month, 1);
        int n = calendar.get(7);
        int n2 = calendar.getActualMaximum(5);
        if (--n == 0) {
            n += 7;
        }
        int n3 = 6 + n;
        for (int i = 1; i <= n2; ++i) {
            this.btn[n3].setText("" + i);
            ++n3;
        }
        this.lbl.setText(simpleDateFormat.format(calendar.getTime()));
    }

    public void setDatePicked(String string) {
        if (!string.equals("")) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year, this.month, Integer.parseInt(string));
            this.pickedDate = calendar.getTime();
            this.returnListener.actionPerformed(new ActionEvent(this, 0, "datePicked"));
        }
    }

    public static Date showDialog(JDialog jDialog) {
        Date date = null;
        final JDialog jDialog2 = new JDialog((Dialog)jDialog, true);
        DatePicker datePicker = new DatePicker(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.setVisible(false);
            }
        });
        jDialog2.getContentPane().add(datePicker);
        jDialog2.pack();
        jDialog2.setVisible(true);
        date = datePicker.pickedDate;
        return date;
    }
}

