/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdesktop.animation.timing.interpolation.Evaluator;

public class KeyValues<T> {
    private final List<T> values = new ArrayList<T>();
    private final Evaluator<T> evaluator;
    private final Class<?> type;
    private T startValue;

    public static <T> KeyValues<T> create(T ... TArray) {
        return new KeyValues<T>(TArray);
    }

    public static <T> KeyValues<T> create(Evaluator evaluator, T ... TArray) {
        return new KeyValues<T>(evaluator, TArray);
    }

    private KeyValues(T ... TArray) {
        this(Evaluator.create(TArray.getClass().getComponentType()), TArray);
    }

    private KeyValues(Evaluator evaluator, T ... TArray) {
        if (TArray == null) {
            throw new IllegalArgumentException("params array cannot be null");
        }
        if (TArray.length == 0) {
            throw new IllegalArgumentException("params array must have at least one element");
        }
        if (TArray.length == 1) {
            this.values.add(null);
        }
        Collections.addAll(this.values, TArray);
        this.type = TArray.getClass().getComponentType();
        this.evaluator = evaluator;
    }

    int getSize() {
        return this.values.size();
    }

    Class<?> getType() {
        return this.type;
    }

    void setStartValue(T t) {
        if (this.isToAnimation()) {
            this.startValue = t;
        }
    }

    boolean isToAnimation() {
        return this.values.get(0) == null;
    }

    T getValue(int n, int n2, float f) {
        T t;
        T t2 = this.values.get(n);
        if (t2 == null) {
            t2 = this.startValue;
        }
        if (n == n2) {
            t = t2;
        } else {
            T t3 = t2;
            T t4 = this.values.get(n2);
            t = this.evaluator.evaluate(t3, t4, f);
        }
        return t;
    }
}

