/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.Evaluator;
import org.jdesktop.animation.timing.interpolation.KeyFrames;
import org.jdesktop.animation.timing.interpolation.KeyValues;

public class PropertySetter
extends TimingTargetAdapter {
    private Object object;
    private String propertyName;
    private KeyFrames keyFrames;
    private Method propertySetter;
    private Method propertyGetter;

    public static Animator createAnimator(int n, Object object, String string, KeyFrames keyFrames) {
        PropertySetter propertySetter = new PropertySetter(object, string, keyFrames);
        Animator animator = new Animator(n, propertySetter);
        return animator;
    }

    public static <T> Animator createAnimator(int n, Object object, String string, T ... TArray) {
        PropertySetter propertySetter = new PropertySetter(object, string, TArray);
        Animator animator = new Animator(n, propertySetter);
        return animator;
    }

    public static <T> Animator createAnimator(int n, Object object, String string, Evaluator evaluator, T ... TArray) {
        PropertySetter propertySetter = new PropertySetter(object, string, evaluator, TArray);
        Animator animator = new Animator(n, propertySetter);
        return animator;
    }

    public PropertySetter(Object object, String string, KeyFrames keyFrames) {
        this.object = object;
        this.propertyName = string;
        this.keyFrames = keyFrames;
        try {
            this.setupMethodInfo();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Bad property name (" + string + "): could not find " + "an appropriate setter or getter method for that property");
        }
    }

    public <T> PropertySetter(Object object, String string, T ... TArray) {
        this(object, string, new KeyFrames(KeyValues.create(TArray)));
    }

    public <T> PropertySetter(Object object, String string, Evaluator evaluator, T ... TArray) {
        this(object, string, new KeyFrames(KeyValues.create(evaluator, TArray)));
    }

    private void setupMethodInfo() throws NoSuchMethodException {
        try {
            String string = this.propertyName.substring(0, 1);
            String string2 = this.propertyName.substring(1);
            Class clazz = this.getType();
            String string3 = "set" + string.toUpperCase() + string2;
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(this.propertyName, this.object.getClass(), null, string3);
            this.propertySetter = propertyDescriptor.getWriteMethod();
            if (this.isToAnimation()) {
                String string4 = "get" + string.toUpperCase() + string2;
                propertyDescriptor = new PropertyDescriptor(this.propertyName, this.object.getClass(), string4, null);
                this.propertyGetter = propertyDescriptor.getReadMethod();
            }
        }
        catch (Exception exception) {
            throw new NoSuchMethodException("Cannot find property methods: " + exception);
        }
    }

    @Override
    public void begin() {
        if (this.isToAnimation()) {
            try {
                this.setStartValue(this.propertyGetter.invoke(this.object, new Object[0]));
            }
            catch (Exception exception) {
                System.out.println("Problem setting start value on object " + this.object + ": " + exception);
            }
        }
    }

    @Override
    public void timingEvent(float f) {
        try {
            this.setValue(this.object, this.propertySetter, f);
        }
        catch (Exception exception) {
            System.out.println("Problem calling setValue in PropertySetter.timingEvent: " + exception);
        }
    }

    private String getPropertyName() {
        return this.propertyName;
    }

    private void setStartValue(Object object) {
        this.keyFrames.getKeyValues().setStartValue(object);
    }

    private void setValue(Object object, Method method, float f) {
        try {
            method.invoke(object, this.keyFrames.getValue(f));
        }
        catch (Exception exception) {
            System.out.println("Problem invoking method " + this.propertySetter + " in object " + object + " in setValue" + exception);
        }
    }

    private Class getType() {
        return this.keyFrames.getType();
    }

    private boolean isToAnimation() {
        return this.keyFrames.getKeyValues().isToAnimation();
    }
}

