/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.LengthItem;

public final class SplineInterpolator
implements Interpolator {
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private ArrayList lengths = new ArrayList();

    public SplineInterpolator(float f, float f2, float f3, float f4) {
        Object object;
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f) {
            throw new IllegalArgumentException("Control points must be in the range [0, 1]:");
        }
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (float f8 = 0.01f; f8 <= 1.0f; f8 += 0.01f) {
            object = this.getXY(f8);
            float f9 = f7 + (float)Math.sqrt((((Point2D.Float)object).x - f5) * (((Point2D.Float)object).x - f5) + (((Point2D.Float)object).y - f6) * (((Point2D.Float)object).y - f6));
            LengthItem lengthItem = new LengthItem(f9, f8);
            this.lengths.add(lengthItem);
            f7 = f9;
            f5 = ((Point2D.Float)object).x;
            f6 = ((Point2D.Float)object).y;
        }
        for (int i = 0; i < this.lengths.size(); ++i) {
            object = (LengthItem)this.lengths.get(i);
            ((LengthItem)object).setFraction(f7);
        }
    }

    private Point2D.Float getXY(float f) {
        float f2 = 1.0f - f;
        float f3 = 3.0f * f * (f2 * f2);
        float f4 = 3.0f * (f * f) * f2;
        float f5 = f * f * f;
        Point2D.Float float_ = new Point2D.Float(f3 * this.x1 + f4 * this.x2 + f5, f3 * this.y1 + f4 * this.y2 + f5);
        return float_;
    }

    private float getY(float f) {
        float f2 = 1.0f - f;
        float f3 = 3.0f * f * (f2 * f2);
        float f4 = 3.0f * (f * f) * f2;
        float f5 = f * f * f;
        return f3 * this.y1 + f4 * this.y2 + f5;
    }

    @Override
    public float interpolate(float f) {
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < this.lengths.size(); ++i) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i);
            float f5 = lengthItem.getFraction();
            float f6 = lengthItem.getT();
            if (f <= f5) {
                float f7 = (f - f4) / (f5 - f4);
                f2 = f3 + f7 * (f6 - f3);
                return this.getY(f2);
            }
            f4 = f5;
            f3 = f6;
        }
        return this.getY(f2);
    }
}

