/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public class ProcessingInstruction
extends Content {
    private static final String CVS_ID = "@(#) $RCSfile: ProcessingInstruction.java,v $ $Revision: 1.47 $ $Date: 2007/11/10 05:28:59 $ $Name: jdom_1_1 $";
    protected String target;
    protected String rawData;
    protected Map mapData;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String string, Map map) {
        this.setTarget(string);
        this.setData(map);
    }

    public ProcessingInstruction(String string, String string2) {
        this.setTarget(string);
        this.setData(string2);
    }

    public ProcessingInstruction setTarget(String string) {
        String string2 = Verifier.checkProcessingInstructionTarget(string);
        if (string2 != null) {
            throw new IllegalTargetException(string, string2);
        }
        this.target = string;
        return this;
    }

    @Override
    public String getValue() {
        return this.rawData;
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.rawData;
    }

    public List getPseudoAttributeNames() {
        Set set = this.mapData.entrySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = string.substring(0, string.indexOf("="));
            arrayList.add(string2);
        }
        return arrayList;
    }

    public ProcessingInstruction setData(String string) {
        String string2 = Verifier.checkProcessingInstructionData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, string2);
        }
        this.rawData = string;
        this.mapData = this.parseData(string);
        return this;
    }

    public ProcessingInstruction setData(Map map) {
        String string = this.toString(map);
        String string2 = Verifier.checkProcessingInstructionData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, string2);
        }
        this.rawData = string;
        this.mapData = map;
        return this;
    }

    public String getPseudoAttributeValue(String string) {
        return (String)this.mapData.get(string);
    }

    public ProcessingInstruction setPseudoAttribute(String string, String string2) {
        String string3 = Verifier.checkProcessingInstructionData(string);
        if (string3 != null) {
            throw new IllegalDataException(string, string3);
        }
        string3 = Verifier.checkProcessingInstructionData(string2);
        if (string3 != null) {
            throw new IllegalDataException(string2, string3);
        }
        this.mapData.put(string, string2);
        this.rawData = this.toString(this.mapData);
        return this;
    }

    public boolean removePseudoAttribute(String string) {
        if (this.mapData.remove(string) != null) {
            this.rawData = this.toString(this.mapData);
            return true;
        }
        return false;
    }

    private String toString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            stringBuffer.append(string).append("=\"").append(string2).append("\" ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private Map parseData(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string.trim();
        while (!string2.trim().equals("")) {
            int n;
            String string3 = "";
            String string4 = "";
            int n2 = 0;
            char c = string2.charAt(n2);
            for (n = 1; n < string2.length(); ++n) {
                char c2 = string2.charAt(n);
                if (c2 == '=') {
                    string3 = string2.substring(n2, n).trim();
                    int[] nArray = ProcessingInstruction.extractQuotedString(string2.substring(n + 1));
                    if (nArray == null) {
                        return new HashMap();
                    }
                    string4 = string2.substring(nArray[0] + n + 1, nArray[1] + n + 1);
                    n += nArray[1] + 1;
                    break;
                }
                if (Character.isWhitespace(c) && !Character.isWhitespace(c2)) {
                    n2 = n;
                }
                c = c2;
            }
            string2 = string2.substring(n);
            if (string3.length() <= 0 || string4 == null) continue;
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private static int[] extractQuotedString(String string) {
        boolean bl = false;
        char c = '\"';
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 != '\"' && c2 != '\'') continue;
            if (!bl) {
                c = c2;
                bl = true;
                n = i + 1;
                continue;
            }
            if (c != c2) continue;
            bl = false;
            return new int[]{n, i};
        }
        return null;
    }

    public String toString() {
        return new StringBuffer().append("[ProcessingInstruction: ").append(new XMLOutputter().outputString(this)).append("]").toString();
    }

    @Override
    public Object clone() {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)super.clone();
        if (this.mapData != null) {
            processingInstruction.mapData = this.parseData(this.rawData);
        }
        return processingInstruction;
    }
}

