/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import org.jdom.Verifier;

class TextBuffer {
    private static final String CVS_ID = "@(#) $RCSfile: TextBuffer.java,v $ $Revision: 1.10 $ $Date: 2007/11/10 05:29:00 $ $Name: jdom_1_1 $";
    private String prefixString;
    private char[] array = new char[4096];
    private int arraySize = 0;

    TextBuffer() {
    }

    void append(char[] cArray, int n, int n2) {
        if (this.prefixString == null) {
            this.prefixString = new String(cArray, n, n2);
        } else {
            this.ensureCapacity(this.arraySize + n2);
            System.arraycopy(cArray, n, this.array, this.arraySize, n2);
            this.arraySize += n2;
        }
    }

    int size() {
        if (this.prefixString == null) {
            return 0;
        }
        return this.prefixString.length() + this.arraySize;
    }

    void clear() {
        this.arraySize = 0;
        this.prefixString = null;
    }

    boolean isAllWhitespace() {
        int n;
        if (this.prefixString == null || this.prefixString.length() == 0) {
            return true;
        }
        int n2 = this.prefixString.length();
        for (n = 0; n < n2; ++n) {
            if (Verifier.isXMLWhitespace(this.prefixString.charAt(n))) continue;
            return false;
        }
        for (n = 0; n < this.arraySize; ++n) {
            if (Verifier.isXMLWhitespace(this.array[n])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.prefixString == null) {
            return "";
        }
        String string = "";
        string = this.arraySize == 0 ? this.prefixString : new StringBuffer(this.prefixString.length() + this.arraySize).append(this.prefixString).append(this.array, 0, this.arraySize).toString();
        return string;
    }

    private void ensureCapacity(int n) {
        int n2 = this.array.length;
        if (n > n2) {
            int n3;
            char[] cArray = this.array;
            for (n3 = n2; n > n3; n3 += n2 / 2) {
            }
            this.array = new char[n3];
            System.arraycopy(cArray, 0, this.array, 0, this.arraySize);
        }
    }
}

