#!/bin/sh
source "/opt/gira/bin/environment"

OVERWRITEZIP='minizip -o -1'
ADDTOZIP='minizip -a'
if [ -f /usr/bin/zip ]; then 
  OVERWRITEZIP='zip -g'
  ADDTOZIP='zip -g'
fi

# minizip cannot store folders and it seems to store only one folder level per command...
${OVERWRITEZIP} "${GENLOGFILETMP}"/logfile.zip ${DEFAULT_LOG_DIR}/*.* ${DEFAULT_LOG_DIR}/messages
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip ${DEFAULT_LOG_DIR}/samba/*
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip ${PERSISTENT_LOG_DIR}/*
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip /opt/userdata/knxdevice/* /opt/userdata/etc/iscapphost/iscapphostconfig.xml

ps w > /tmp/ps_w.txt
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip ps_w.txt
rm /tmp/ps_w.txt

ps l > /tmp/ps_l.txt
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip ps_l.txt
rm /tmp/ps_l.txt

dmesg > /tmp/dmesg.txt
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip dmesg.txt
rm /tmp/dmesg.txt

uptime > /tmp/uptime.txt
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip uptime.txt
rm /tmp/uptime.txt

df -h > /tmp/df.txt
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip df.txt
rm /tmp/df.txt

/opt/gira/bin/devcfg > /tmp/devcfg.txt
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip devcfg.txt
rm /tmp/devcfg.txt

wget http://127.0.0.1:65155/status.html -O /tmp/DeviceStatus.html
if [ ! -s /tmp/DeviceStatus.html ]; then
  echo "get index.html instead"
  wget http://127.0.0.1:65155/index.html -O /tmp/DeviceStatus.html
fi
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip DeviceStatus.html
rm /tmp/DeviceStatus.html

# The IscWebservice will generate COStates and DeviceInfo files
if [ -f /tmp/deviceinfo.json ]; then 
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip deviceinfo.json
rm /tmp/deviceinfo.json
fi

if [ -f /tmp/coStates.json ]; then 
cd /tmp
${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip coStates.json
rm /tmp/coStates.json
fi

if [ -f /opt/userdata/isc/sdk.crt ]; then 
  ${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip /opt/userdata/isc/sdk.crt 
fi

if [ -f /opt/userdata/isc/appfiles.xml ]; then 
  ${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip /opt/userdata/isc/appfiles.xml /opt/userdata/isc/appfiles.xml.SHA256.sig
fi

if [ -f /opt/userdata/devicestack/iscOM/config.json ]; then 
  ${ADDTOZIP} "${GENLOGFILETMP}"/logfile.zip /opt/userdata/devicestack/iscOM/config.json
fi

# add product specific files, default is /opt/userdata/iscAppConfigRoot
source "/opt/gira/bin/product_logfiles.sh"

product_logfiles
