/*
 * ##################################################### Start MainSite Addon #####################################################
 */

MainSite.prototype.getKimFriendlyName = function() {
  return 'ise KNX viega'
}

MainSite.prototype.addProductTopNavMenuItems = function() {
  this.pages['LoginPage'] = new LoginPage();

  this.menu.insertAfter(new MenuItem('base_station_configuration', 'BaseStationPage'), this.menu.device_status);
  this.pages['BaseStationPage'] = new BaseStationPage();

  this.menu.add(new MenuItem('user', new Menu(new MenuItem('change_password', 'ChangePasswordPage'))));
  this.pages['ChangePasswordPage'] = new ChangePasswordPage();

  this.menu.user.target.add(new MenuItem('logout', 'LogoutPage'));
  this.pages['LogoutPage'] = new LogoutPage();

  mainSite.homepage = this.pages['BaseStationPage'];
}

/*
 * ##################################################### End MainSite Addon #####################################################
 */

/*
* ##################################################### Start StatusPage Addon #####################################################
*/
StatusPage.prototype.appendDOMFragmentCOInfosTo = function(parentElement) {
  var span = document.createElement('span');
  span.setAttribute('hidden', '');
  var thisClass = this;
  thisClass.dataBindings.push(
    function() {
      if (mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload) {
        span.removeAttribute('hidden');
      } else {
        span.setAttribute('hidden', '');
      }
    }
  );
  parentElement.appendChild(span);
  parentElement = span;
  var elem = document.createElement('b');
  elem.appendChild(document.createTextNode(i18n.translate('general_information') + ':'));
  parentElement.appendChild(elem)

  parentElement.appendChild(document.createElement('br'));
  var exampleCO = 1; //add translation element  ('co_state_' + exampleCO) to translation files
  this.appendDOMFragmentKimCoInfoTo(parentElement, exampleCO);

  parentElement.appendChild(document.createElement('br'));
  var thisClass = this;

}

StatusPage.prototype.prepareAppInfo = function(divAppInfomation) {
  headerAppInformation = document.createElement('h3');
  headerAppInformation.setAttribute('class', 'h3');
  headerAppInformation.appendChild(document.createTextNode(i18n.translate('application_information')));
  divAppInfomation.appendChild(headerAppInformation);

  var fragmentAppState = document.createElement('span');
  fragmentAppState.setAttribute('hidden', '');
  divAppInfomation.appendChild(fragmentAppState);
  this.appendDOMFragmentAppStateTo(fragmentAppState);

  var thisClass = this;
  thisClass.dataBindings.push(
    function() {
      if (mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload) {
        fragmentAppState.removeAttribute('hidden');
      } else {
        fragmentAppState.setAttribute('hidden', '');
      }
    }
  );

  // Enable this for CO Infos.
  // this.appendDOMFragmentCOInfosTo(divAppInfomation);

  divAppInfomation.appendChild(document.createElement('br'));
}
//Example for default handling of Boolean COs and specific String COs handling
StatusPage.prototype.updateCO = function(span, textNode, currentCO) {
  switch (currentCO.id) {
    case 1: //Example for String DPT as error state CO
      //     textNode.nodeValue = i18n.translate(currentCO.value);
      //     if (currentCO.value == 'None' || currentCO.value == 'False') {
      //       span.setAttribute('class', 'text--success');
      //     } else if (currentCO.value) {
      //       span.setAttribute('class', 'text--error');
      //     }
      break;
    default:
      //     if (currentCO.value == '1') {
      //       span.setAttribute('class', 'text--success');
      //       textNode.nodeValue = i18n.translate('True');
      //     } else if (currentCO.value == '0') {
      //       span.setAttribute('class', 'text--error');
      //       textNode.nodeValue = i18n.translate('False');
      //     }
      break;
  }
}
/*
 * ##################################################### End StatusPage Addon #####################################################
 *//*###################################################### www/web/BaseStation.js #############################################*/
// Only works in Chrome and FireFox, does not work in IE:
Object.setPrototypeOf = Object.setPrototypeOf || function(obj, proto) {
  obj.__proto__ = proto;
  return obj; 
}

/*
 * ##################################################### Start BaseStation #####################################################
 */
function BaseStationPage() {
  this.baseStations = []

  if (!(this instanceof BaseStationPage)) {
    return new BaseStationPage();
  }
  PageTemplate.call(this);
  var thisClass = this;

  this.prepare = function() {
    IscWebService('setKeepAlive', '', function(response) {});
    if (!thisClass.contentSection) {
      thisClass.contentSection = document.createElement('div');
      var header = document.createElement('h3');
      header.setAttribute('class', 'h3');
      header.appendChild(document.createTextNode(i18n.translate('base_station_configuration')));
      thisClass.contentSection.appendChild(header);

      var divBasicStations = document.createElement('div');
      divBasicStations.setAttribute('class', 'narrow');

      var baseStations = document.createElement('fieldset');

      var headerBaseStations = document.createElement('legend');
      headerBaseStations.appendChild(document.createTextNode(i18n.translate('base_stations')));
      baseStations.appendChild(headerBaseStations);
      this.updateBaseStations = function(){
        for(var baseStation in thisClass.baseStations){
          Object.setPrototypeOf(thisClass.baseStations[baseStation], BaseStation.prototype);
          thisClass.baseStations[baseStation].appendTo(baseStations);
        }
      };

      divBasicStations.appendChild(baseStations);
      thisClass.contentSection.appendChild(divBasicStations);
    }
    mainSite.main.appendChild(thisClass.contentSection);
    thisClass.requestData();
    thisClass.update();
  };
  this.setFocus = undefined;

  this.setBaseStationConfig = function(response) {
    if (response && response.data && response.data.baseStations) {
        for(var baseStation in response.data.baseStations){
          var index = response.data.baseStations[baseStation].index;
          if (!thisClass.baseStations[index]){
            thisClass.baseStations[index] = Object.setPrototypeOf(response.data.baseStations[baseStation], BaseStation.prototype);
          }
          else{
            thisClass.baseStations[index].updateData(response.data.baseStations[baseStation])
          }
        }
    }
  }
  this.updateBaseStations = function(){};
  
  this.requestData = function() {
    mainSite.timer.getDeviceInfo.oneShot();
    if (!mainSite.timer.GetReadBaseStationConfig) {
      mainSite.timer.ViegaBaseStationConfig = new TimedRequest(INTERVAL.MINUTE, 'getViegaBaseStationConfig', '', thisClass.setBaseStationConfig, thisClass);
    } else {
      mainSite.timer.ViegaBaseStationConfig.timeout = INTERVAL.MINUTE;
    }
    mainSite.timer.ViegaBaseStationConfig.addCallbackFunction(thisClass.updateBaseStations);
    mainSite.timer.ViegaBaseStationConfig.oneShot();
  };

  this.update = function() {
    if (thisClass.visible) {
      //update data in site
      for (var i = 0; i < thisClass.dataBindings.length; i++) {
        thisClass.dataBindings[i]();
      }
    }
  };
}
BaseStationPage.prototype = new PageTemplate();
BaseStationPage.prototype.constructor = BaseStationPage;
/*
 * ##################################################### End BaseStationPage #####################################################
 */
 
/*
 * ##################################################### Begin BaseStation #####################################################
 */
function BaseStation() {
  thisClass = this;
  this.showSerialNumberEnabled = false;
  this.index = undefined;
  this.serialNumber = undefined;
  this.username = undefined;
  this.credentials = undefined;
  this.documentElement = undefined;
}

BaseStation.prototype.appendTo = function(parentElement) {
  if (this.documentElement == undefined){
    this.documentElement = document.createElement('p');

    var baseStationIndexLbl = document.createElement('span');
    baseStationIndexLbl.setAttribute('style','font-weight:bold;');
    baseStationIndexLbl.appendChild(document.createTextNode(i18n.translate('base_unit') + ': '));
    this.documentElement.appendChild(baseStationIndexLbl);
    var baseStationIndexTxt = document.createTextNode(this.index + 1);
    this.documentElement.appendChild(baseStationIndexTxt);

    if (this.showSerialNumberEnabled){
      var serialNumberLbl = document.createElement('span');
      serialNumberLbl.setAttribute('style','margin-left: 2em; font-weight:bold;');
      serialNumberLbl.appendChild(document.createTextNode(i18n.translate('serial_number') + ': '));
      this.documentElement.appendChild(serialNumberLbl);
      var serialNumberTxt = document.createTextNode(this.serialNumber);
      this.documentElement.appendChild(serialNumberTxt);
    }    
    
    var credentialsStatusLbl = document.createElement('span');
    credentialsStatusLbl.setAttribute('style','margin-left: 2em; font-weight:bold;');
    credentialsStatusLbl.appendChild(document.createTextNode(i18n.translate('credentials_configured') + ': '));
    this.documentElement.appendChild(credentialsStatusLbl);
    var credentialsStatus = document.createElement('span');
    credentialsStatus.setAttribute('class', 'icon ' + (this.credentials?'text--success':'text--error'));
    var credentialsStatusTxt = document.createTextNode(decodeURI((this.credentials?'\uE207':'\uE200')) + ' ');
    credentialsStatus.appendChild(credentialsStatusTxt);
    this.documentElement.appendChild(credentialsStatus);
    var changeCredentials = document.createElement('button');
    changeCredentials.setAttribute('class', 'button--xxsm');
    changeCredentials.setAttribute('style','margin-left: 2em;');
    var credentialsButtonTxt = document.createTextNode(i18n.translate('configure_credentials'));
    changeCredentials.appendChild(credentialsButtonTxt);
    var thisClass = this;
    changeCredentials.onclick = function() {

      changeCredentials.setAttribute('disabled', true);
      var dialog = new ModalCredentialsDialog(i18n.translate('credentials_dialog_header'), i18n.translate('credentials_dialog_info').replace(/SERIAL_NUMBER/gi,
                  function(subst) {
                    switch (subst) {
                      case 'SERIAL_NUMBER':
                        return (thisClass.showSerialNumberEnabled?thisClass.serialNumber:thisClass.index+1);
                    }
                  }), thisClass.username, i18n.translate('credentials_send'));
      dialog.prepare();
      dialog.setCallbackFunction(function(returnValue){
        if (returnValue){
            var data = {'index': thisClass.index, 'username': returnValue.username, 'credentials': returnValue.credentials};
          if (thisClass.serialNumber) {
            data.serialNumber = thisClass.serialNumber;
          }
          IscWebService('setViegaBaseStationConfig', data, function(response) {
            if (response == undefined) {
              new ModalConfirmDialogOk(i18n.translate('something_wrong'), i18n.translate('device_unavailable')).prepare();
            } else if (response.error) {
              DisplayError(response);
              thisClass.credentials = false;
              thisClass.update();
            } else {
              if (returnValue){
                thisClass.username = returnValue.username;
              }
              thisClass.credentials = true;
              thisClass.update();
            }
          });
        }
        changeCredentials.removeAttribute('disabled');
      });
    }
    this.documentElement.appendChild(changeCredentials);
    
    var deleteCredentials = document.createElement('button');
    deleteCredentials.setAttribute('class', 'button--xxsm');
    deleteCredentials.setAttribute('style','margin-left: 2em;');
    if (!this.credentials){
      deleteCredentials.setAttribute('disabled','true');
    }
    var credentialsButtonTxt = document.createTextNode(i18n.translate('delete_credentials'));
    deleteCredentials.appendChild(credentialsButtonTxt);
    deleteCredentials.onclick = function() {
      var data = {'index': thisClass.index};
      IscWebService('setViegaBaseStationConfig', data, function(response) {
        if (response == undefined) {
          new ModalConfirmDialogOk(i18n.translate('something_wrong'), i18n.translate('device_unavailable')).prepare();
        } else if (response.error) {
          DisplayError(response);
          thisClass.username = undefined;
          thisClass.update();
        } else {
          thisClass.username = undefined;
          thisClass.credentials = false;
          thisClass.update();
          deleteCredentials.setAttribute('disabled','true');
        }
      });
    };
    this.documentElement.appendChild(deleteCredentials);

    parentElement.appendChild(this.documentElement);
    this.update = function(){
      if (this.index !== undefined){
        baseStationIndexTxt.nodeValue = this.index + 1;
      }
      if (this.showSerialNumberEnabled && this.serialNumber !== undefined){
        serialNumberTxt.nodeValue = this.serialNumber;
      }
      credentialsStatus.setAttribute('class', 'icon ' + (this.credentials?'text--success':'text--error'));
      credentialsStatusTxt.nodeValue = decodeURI((this.credentials?'\uE207':'\uE200')) + ' ';
      if (this.credentials){
        deleteCredentials.removeAttribute('disabled');
      }
      else{
        deleteCredentials.setAttribute('disabled','true');
      }
    }
  this.update();
  return this.documentElement;
  }
  this.update();
  return;
}
BaseStation.prototype.updateData = function(other){
  this.index = other.index;
  this.username = other.username;
  this.serialNumber = other.serialNumber;
  this.credentials = other.credentials;
  
}

BaseStation.prototype.update = function() {}


BaseStation.prototype.changeCredentials = function() {
  
}
/*
 * ##################################################### End BaseStation #####################################################
 */
 
/*
 * ##################################################### Begin ModalCredentialsDialog #####################################################
 */
 function ModalCredentialsDialog(modalHeaderText, modalBodyText, username, btnOKText, btnCancelText) {
  ModalDialog.call(this, modalHeaderText, modalBodyText);
  var thisClass = this;
  this.id = 'CredentialsDialog';
  this.username = username || "";
  var btnOKText = btnOKText || i18n.translate('btn_ok');
  var btnCancelText = btnCancelText || i18n.translate('btn_cancel');
  this.callbackFunction = function() {};
  this.setCallbackFunction = function(newCallbackFunction) {
    thisClass.callbackFunction = newCallbackFunction;
  }
  this.onOk = undefined;
  this.onCancel = function() {
    thisClass.callbackFunction(false);
    thisClass.close();
  };
  
    this.prepareDialog = function() {
    thisClass.modalContainer = document.createElement('div');
    thisClass.modalContainer.setAttribute('class', 'modal-container');
    thisClass.modalHeader = document.createElement('div');
    thisClass.modalHeader.setAttribute('class', 'modal-header');
    thisClass.modalHeader.appendChild(document.createTextNode(modalHeaderText));
    var modalClose = document.createElement('a');
    modalClose.setAttribute('class', 'modal-close');
    modalClose.setAttribute('href', '#close');
    modalClose.onclick = thisClass.onCancel;
    modalClose.appendChild(document.createTextNode('\u00D7'));
    thisClass.modalHeader.appendChild(modalClose);
    thisClass.modalBody = document.createElement('div');
    thisClass.modalBody.setAttribute('class', 'modal-body');
    thisClass.modalBody.appendChild(document.createTextNode(modalBodyText));

    var formCredentials = document.createElement('form');
    var pUsername = document.createElement('p');
    var labelUsername = document.createElement('label');
    labelUsername.setAttribute('for', 'username');
    labelUsername.appendChild(document.createTextNode(i18n.translate('local_username')));
    pUsername.appendChild(labelUsername);
    var inputUsername = document.createElement('input');
    inputUsername.setAttribute('type', 'text');
    inputUsername.setAttribute('id', 'username');
    inputUsername.setAttribute('pattern', '[^:]{1,255}');
    inputUsername.setAttribute('required', '');
    inputUsername.setAttribute('autofocus', '');
    inputUsername.value = thisClass.username;
    pUsername.appendChild(inputUsername);
    formCredentials.appendChild(pUsername);

    thisClass.setFocus = function(){
      inputUsername.focus();
    };

    var pPassword = document.createElement('p');
    var labelPassword = document.createElement('label');
    labelPassword.setAttribute('for', 'password');
    labelPassword.appendChild(document.createTextNode(i18n.translate('password')));
    pPassword.appendChild(labelPassword);
    var inputPassword = document.createElement('input');
    inputPassword.setAttribute('type', 'password');
    inputPassword.setAttribute('id', 'password');
    inputPassword.setAttribute('required', '');
    inputPassword.setAttribute('pattern', '.{1,255}');
    pPassword.appendChild(inputPassword);
    formCredentials.appendChild(pPassword);
    var submitElem = document.createElement('input');
    submitElem.setAttribute('type', 'submit');
    submitElem.setAttribute('style', 'display:none;');
    formCredentials.appendChild(submitElem);
    thisClass.modalBody.appendChild(formCredentials);
    
    thisClass.onOk = function(){
      submitElem.click();
    }
    formCredentials.onsubmit = function(event) {
      event.preventDefault();
      if (!event.target.checkValidity()) {
        return;
      }
      if (inputUsername.checkValidity() && inputPassword.checkValidity()){
        var md5hasher = forge.md.md5.create();
        md5hasher.update(inputUsername.value + ':Viega:' + inputPassword.value);
        thisClass.callbackFunction({"username": inputUsername.value, "credentials": forge.util.encode64(forge.util.bytesToHex(md5hasher.digest().getBytes()))});
        thisClass.close();
      }
    };

    thisClass.modalFooter = document.createElement('div');
    thisClass.modalFooter.setAttribute('class', 'modal-footer ');
    thisClass.modalContainer.appendChild(thisClass.modalHeader);
    thisClass.modalContainer.appendChild(thisClass.modalBody);
    thisClass.modalContainer.appendChild(thisClass.modalFooter);
  };
  
  this.prepare = function() {
    if (!thisClass.modalContainer) {
      thisClass.prepareDialog();
      thisClass.prepareOKCancel();
    }
    thisClass.show();
    thisClass.setFocus();
    return thisClass.modalContainer;
  };
  
  this.setFocus = undefined;
  
  this.prepareOKCancel = function() {
    var okCancelUl = document.createElement('ul');
    var okLi = document.createElement('li');
    var okButton = document.createElement('button');
    okButton.setAttribute('class', 'button--xsm');
    okButton.setAttribute('column', '2');
    okButton.onclick = thisClass.onOk;
    okButton.appendChild(document.createTextNode(btnOKText));
    okLi.appendChild(okButton);
    okCancelUl.appendChild(okLi);
    var cancelLi = document.createElement('li');
    var cancelButton = document.createElement('button');
    cancelButton.setAttribute('class', 'button--xsm');
    cancelButton.setAttribute('column', '2');
    cancelButton.onclick = thisClass.onCancel;
    cancelButton.appendChild(document.createTextNode(btnCancelText));
    cancelLi.appendChild(cancelButton);
    okCancelUl.appendChild(cancelLi);
    thisClass.modalFooter.appendChild(okCancelUl);
  }

}
ModalCredentialsDialog.prototype = new ModalDialog();
ModalCredentialsDialog.prototype.constructor = ModalCredentialsDialog;
/*
 * ##################################################### End ModalCredentialsDialog #####################################################
 */
/*###################################################### www/web/BaseStation.js #############################################*/
