#!/bin/sh
#
# Set links to /opt/userdata/debug for KIM binaries and libraries.
#

#
# Parameter
#
DEBUGBIN=/opt/userdata/debug/opt/gira/bin
DEBUGLIB=/opt/userdata/debug/opt/gira/lib
TARGETBIN=/opt/gira/bin
TARGETLIB=/opt/gira/lib

#
# Remount system writeable
#
mount -o remount,rw /

#
# Check and link bin files
#
if [ -d "${DEBUGBIN}" ]; then
        for entry in ${DEBUGBIN}/*
        do
                echo "Processing '${entry}'..."
                file=`basename ${entry}`
                rm -f ${TARGETBIN}/${file}
                ln -s ${DEBUGBIN}/${file} ${TARGETBIN}/${file}
        done
fi

#
# Check and link lib files
#
if [ -d "${DEBUGLIB}" ]; then
        for entry in ${DEBUGLIB}/*
        do
                # process only the files, no symlinks
                if [ ! -L ${entry} ]; then
                        echo "Processing '${entry}'..."
                        file=`basename "${entry}"`
                        purefile=`basename "${entry}" | sed "s/\.so.*/\.so/"`
                        rm -f ${TARGETLIB}/${purefile}
                        rm -f ${TARGETLIB}/${purefile}.*
                        ln -s ${DEBUGLIB}/${file} ${TARGETLIB}/${file}
                        ln -s ${DEBUGLIB}/${file} ${TARGETLIB}/${purefile}
                fi;
        done
fi

#
# Remount system readonly
#
mount -o remount,ro /
