/******************************************************************************
*
* File: main.c
*
* Description: This module contains the main function(s) of the user application
*              program
*
* Date: 9/2/2008
*
* Generates: BIM_M13x Wizard
*
******************************************************************************/
#include "BIM_M13x.h"
#define TOGGLETIME MSEC200

TIMER_TAB UserTimerTab;
// ram flags for communication objects
BYTE RAMFlags[(NUM_OF_COM_OBJ / 2) + 1];

// communication objects
BYTE   Obj0;
BYTE   Obj1;
BYTE   Obj2;

/******************************************************************************/


void AppInit(void)
{
    // init the user application timer table
    U._TmInit(NUM_OF_TIMERS);

    // after initialization a taskswitch must be done because
    // the task switch is disabled at cstartup
    FORCE_TASKSWITCH();
}

//------------------------------------------------------------------------
//  This is the main function of the application program
//  It is called at the end of cstartup
//------------------------------------------------------------------------
void main (void)
{
    // Do some initializations
    AppInit();

    // Start the main loop of the application program
    // it will be interrupted every 3.3ms and
    // continued after a complete system cycle
    for(;;)
    {
        // check object 0, it determines the mode to operate
        // also set testpin 4 to the value of object 0
        if (U._TestObject(CO_OBJ0) == TRUE)
        {
            if (Obj0 == 0)
            {
                TESTPIN4_OFF();
            }
            else
            {
                TESTPIN4_ON();
            }
        }

        // check object 1
        // also set testpin 3 to the value of object 1
        if (U._TestObject(CO_OBJ1) == TRUE)
        {
            if (Obj1 == 0)
            {
                TESTPIN3_OFF();
            }
            else
            {
                TESTPIN3_ON();
            }

            // handle object 0 dependent on mode (object 1)
            if(Obj0 == 0)
            {
                // object 1 is 0, so we are in switch mode
                // simply set object 2 to the value of object 1
                // so actuator will be high when sensor is high and vice versa
                U._SetAndTransmitObject(CO_OBJ2, (void*)&Obj1, 1);
            }
            else
            {
                // object 1 is 1, so we are in toggle mode
                // if sensor is high toggle the actuator by starting the timer
                // if sensor is low stop toggling by stopping the timer
                if(Obj1 == 1)
                {
                    U._TmStart(&UserTimerTab.Timers[0], TOGGLETIME);
                }
                else
                {
                    U._TmStop(&UserTimerTab.Timers[0]);
                }
            }
        }

        // if the timer is running and is exipred we must do something
        if(U._TmIsRunning(&UserTimerTab.Timers[0]))
        {
            if(U._TmIsExpired(&UserTimerTab.Timers[0]))
            {
                // invert object2, set and transmit it
                // restart the timer
                BYTE tmp = Obj2;
                if(tmp == 0)
                {
                    tmp = 1;
                }
                else
                {
                    tmp = 0;
                }
                U._SetAndTransmitObject(CO_OBJ2, (void*)&tmp, 1);
                U._TmAddStart(&UserTimerTab.Timers[0], TOGGLETIME);
            }
        }     
    }
}

//------------------------------------------------------------------------
//  This function is called on loss of power
//------------------------------------------------------------------------
void save()
{
}

//------------------------------------------------------------------------
//  This function is called if there was an
//  unload of the application program
//------------------------------------------------------------------------
void unload()
{
}

const BYTE NbComsOb = NUM_OF_COM_OBJ;
const CObjPtr CObjects[] =      // set table for com objects
{
    (void*)&NbComsOb,           // ptr to number of cobjects
//------------------------------------------------------------------------
//  Here the addresses of the communication objects are specified
//------------------------------------------------------------------------
    &Obj0,
    &Obj1,
    &Obj2
};

//------------------------------------------------------------------------
//  In the application info block the application program gives some
//  necessary information for the operation system
//------------------------------------------------------------------------
#pragma constseg = APPINFOBLOCK
const AppInfoBlock AIB =
{
    Swap(0x0001),                   // AIBVersion
    0x01, 0x01,                     // ApplFirmwareVersion, ApplFirmwareSubVersion
    __program_start,                // AppMain
    save,                           // AppSave
    unload,                         // AppUnload
    CObjects,                       // pCObjects
    RAMFlags,                       // pRAMFlags
    &UserTimerTab,                  // pUserTimerTab
    NULL,                           // pUsrIntObjRoot
    NULL,                           // pUsrParamMgmt
    0x0000                          // WatchDogTime
};
#pragma constseg = default
