/******************************************************************************
*
* File: tables.c
*
* Description: This module contains the address table, association table and
*              communication object table.
*
* Date: 9/2/2008
*
* Generates: BIM_M13x Wizard
*
******************************************************************************/
#include "BIM_M13x.h"

#pragma constseg = ADDRTAB
__root const BYTE AdrTab[] =
{     NUM_OF_COM_OBJ + 1,   // for debug: one group address per communication object
                            // (group addresses must be sorted in ascending order!)
      0xFF, 0xFF,           // physical address
      // group addresses
      0x24, 0x00,      0x24, 0x01,      0x24, 0x02,
      0x00                  // padding
};
#pragma constseg = ASSOCTAB
__root const BYTE AssTab[] =
{     NUM_OF_COM_OBJ + 0,   // for debug: one association per communication object
                            // (sorted in ascending order by the second byte of the
                            //  association. If a communication object has no
                            //  association the association has to be (0xFE, [objnum]).
                            //  A communication object has only one sending group address.
                            //  This is the group address that is specified by the
                            //  association at the "communication object number"-position
                            //  in the association table.)
//    grp.addr.,  comobj. num.,        grp.addr.,  comobj. num.,
           0x01,          0x00,             0x02,          0x01,  
           0x03,          0x02,  
      0x00                  // padding
};
#pragma constseg = COMTAB
__root const BYTE EE_CommsTab[] =
{     NUM_OF_COM_OBJ,       // number of communication objects,
                0x00,       // pointer to RAMFlags is not longer used
                            // but must be specified for compatibility
/*Obj0*/      VALID_BCU2ADR, (COMM_ENABLE + WRITE_ENABLE + TRANSMIT_ENABLE + READ_ENABLE + TX_LOW), UINT1,
/*Obj1*/      VALID_BCU2ADR, (COMM_ENABLE + WRITE_ENABLE + TRANSMIT_ENABLE + READ_ENABLE + TX_LOW), UINT1,
/*Obj2*/      VALID_BCU2ADR, (COMM_ENABLE + WRITE_ENABLE + TRANSMIT_ENABLE + READ_ENABLE + TX_LOW), UINT1
};
#pragma constseg = default
