/******************************************************************************
*
* File: tables.c
*
* Description: This module contains the address table, association table and
*              communication object table.
*
* Date: 01/31/2007
*
* Revision: 1
*
* (C) 2007 Copyright Siemens AG
*
* Author: Schiekofer
*
* Modified:
*
* Changes:
*
******************************************************************************/
#include "BIM_M13x.h"

#pragma constseg = ADDRTAB
const BYTE AdrTab[] =
{     NUM_OF_COM_OBJ + 1,   // for debug: one group address per communication object
      0xFF, 0xFF,           // physical address
      // group addresses
      0x00                  // padding
};
#pragma constseg = ASSOCTAB
const BYTE AssTab[] =
{     NUM_OF_COM_OBJ + 0,   // for debug: one association per communication object
      0x00                  // padding
};
#pragma constseg = COMTAB
const BYTE EE_CommsTab[] =
{     NUM_OF_COM_OBJ, 0x00, // number of communication objects,
                            // pointer to RAMFlags is not longer used
                            // but must be specified for compatibility
};
#pragma constseg = default
